package cn.com.duibaboot.ext.autoconfigure.perftest.cloud.netflix.ribbon;

import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 *
 * Created by guoyanfei .
 * 2022/2/23 .
 */
@Configuration
@ConditionalOnClass({ IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class PerfTestRibbonCustomAutoConfiguration {

    /**
     * ribbon列表过滤器,此类用于跟压测配合，用于隔离压测流量和正常流量，压测专用服务在注册到eureka中时会附带压测场景ID ，当前服务在发起调用前需要判读如下逻辑：
     * <br/>
     * 1. 如果当前机器带有场景ID，则过滤eureka服务列表的时候只会选择有相同场景ID的目标服务器进行调用，如果找不到对应的机器，则直接把所有机器都过滤掉(报错)
     * 2. 如果当前机器没带场景ID，则过滤eureka服务列表的时候只会选择没有场景ID的目标服务器进行调用
     *
     * <br/>
     * 这个类不能加到压测包下，因为压测包下的类只有在引入perftest模块的情况下才会生效，而此类在没有引入perftst模块的情况下也应该生效，否则正常流量可能会调用到压测专用服务器上。
     * <br/>
     */
    @Bean
    public PerfTestRibbonServerListFilter perfTestRibbonServerListFilter(){
        return new PerfTestRibbonServerListFilter();
    }

}
