package cn.com.duibaboot.ext.autoconfigure.perftest.core;

import org.springframework.boot.context.properties.ConfigurationProperties;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * 压测相关的配置
 * Created by guoyanfei .
 * 2022/3/7 .
 */
@ConfigurationProperties(prefix = "duiba.perftest")
public class PerfTestProperties {

    /**
     * 全局不支持压测的应用list，在RPC调用的时候，判断如果是调用这些服务，那么直接走生产机器
     * 注意：只支持service类应用，不支持web应用（网关层不处理这块逻辑，按照正常压测流程进行调用，如果web层都走生产流程，那么整条压测链路都是生产链路了，压测链路也就没有意义了）
     */
    private List<String> globalUnsupportedApps;

    /**
     * 自定义不支持压测的应用list，在RPC调用的时候，判断如果是调用这些服务，那么直接走生产机器
     * 注意：只支持service类应用，不支持web应用（网关层不处理这块逻辑，按照正常压测流程进行调用，如果web层都走生产流程，那么整条压测链路都是生产链路了，压测链路也就没有意义了）
     */
    private List<String> customUnsupportedApps;

    public List<String> getGlobalUnsupportedApps() {
        return globalUnsupportedApps;
    }

    public void setGlobalUnsupportedApps(List<String> globalUnsupportedApps) {
        this.globalUnsupportedApps = globalUnsupportedApps;
    }

    public List<String> getCustomUnsupportedApps() {
        return customUnsupportedApps;
    }

    public void setCustomUnsupportedApps(List<String> customUnsupportedApps) {
        this.customUnsupportedApps = customUnsupportedApps;
    }

    @PostConstruct
    public void init() {
        UnsupportedAppsHolder._setUnsupportedApps(this);
    }
}
