package cn.com.duibaboot.ext.autoconfigure.perftest.elasticjob;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import io.elasticjob.autoconfigure.ZookeeperProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;

/**
 * 压测专用容器的ElasticJob在启动的时候，需要和正式的容器注册的应用名进行区分
 * 比如应用 prism
 * 正式的namespace为：elastic-job/prism
 * 压测的namespace为：elastic-job/prism--perf-123
 * 其中123为压测场景id
 *
 * 这个类用于对压测机器的elasticjob进行根据场景id分组，目前未生效，考虑到job中可能存在通过http方式调用其他服务，影响正式
 * Created by guoyanfei .
 * 2022/2/25 .
 */
@Deprecated
public class PerfTestElasticJobBeanPostProcessor implements BeanPostProcessor {

    private static final String ELASTICJOB_PERFTEST_NAMESPACE_SUFFIX_FORMAT = "--perf-%s";
    private static final String ELASTICJOB_PERFTEST_NAMESPACE_FORMAT = "elastic-job/%s" + ELASTICJOB_PERFTEST_NAMESPACE_SUFFIX_FORMAT;

    @Value("${spring.application.name}")
    private String currentAppName;

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!ZookeeperProperties.class.isAssignableFrom(bean.getClass())) {
            return bean;
        }
        // 如果当前不是压测环境，直接返回bean
        if (!PerfTestUtils.isPerfTestEnv()) {
            return bean;
        }

        String sceneId = PerfTestUtils.getSceneId();

        ZookeeperProperties properties = (ZookeeperProperties) bean;
        String namespace = properties.getNamespace();
        if (StringUtils.isBlank(namespace) ||
            !namespace.endsWith(String.format(ELASTICJOB_PERFTEST_NAMESPACE_SUFFIX_FORMAT, sceneId))) {
            properties.setNamespace(String.format(ELASTICJOB_PERFTEST_NAMESPACE_FORMAT, currentAppName, sceneId));
        }

        return bean;
    }
}
