package cn.com.duibaboot.ext.autoconfigure.perftest.rocketmq;

import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.ConfigurableEnvironment;

import java.util.Map;

import static cn.com.duiba.boot.perftest.PerfTestConstant.*;

/**
 * 压测需要把rocketmq的namesrv替换掉
 * Created by guoyanfei .
 * 2022/3/4 .
 */
public final class RocketMQPerfTestUtils {

    private RocketMQPerfTestUtils() {
    }

    public static void configProperties(ConfigurableEnvironment environment, Map<String, Object> perftestPropertyMap) {
        // 替换nameSrv地址
        handleRocketMQNameSrvAddr(environment, perftestPropertyMap);
    }

    private static void handleRocketMQNameSrvAddr(ConfigurableEnvironment environment, Map<String, Object> perftestPropertyMap) {
        String perfNameSrv = environment.getProperty(ROCKETMQ_NAMESRV_PROP_PERF_KEY);
        if (StringUtils.isNotBlank(perfNameSrv)) {
            perftestPropertyMap.put(ROCKETMQ_NAMESRV_PROP_KEY, perfNameSrv);
        }

        String perfNameSrvNew = environment.getProperty(ROCKETMQ_NAMESRV_PROP_PERF_KEY_NEW);
        if (StringUtils.isNotBlank(perfNameSrvNew)) {
            perftestPropertyMap.put(ROCKETMQ_NAMESRV_PROP_KEY_NEW, perfNameSrvNew);
        }
    }
}
