package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import com.dangdang.ddframe.job.spring.schedule.SpringJobScheduler;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

/**
 * 修复elasticjob与spring-cloud不兼容的问题，elasticjob过早调用了feign，报出超时问题，这里尝试延迟到容器启动完成后再执行任务
 */
@Configuration
public class ElasticJobFixAutoConfiguration {

    /**
     * elastic job 1.*
     */
    @Configuration
    @ConditionalOnClass(SpringJobScheduler.class)
    public static class ElasticJob1Configuration {

        @EventListener(WebServerInitializedEvent.class)
        public void onEvent(WebServerInitializedEvent event){
            DelayedThreadExecutor.startAllTaskThreads();
        }
    }

}
