package cn.com.duibaboot.ext.autoconfigure.grouping.filter;

import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * 服务分组用的Filter，当从request中识别到需要分组的请求时，设置context
 * Created by guoyanfei .
 * 2018/11/7 .
 */
@Slf4j
public class ServiceGroupFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String groupKey = ServiceGroupUtils.getDuibaServiceGroupKey((HttpServletRequest) request);

        if (StringUtils.isNotBlank(groupKey)) {
            ServiceGroupContext.setGroupKey(groupKey);
        }
        try {
            chain.doFilter(request, response);
        } finally {
            ServiceGroupContext.removeGroupKey();
        }
    }

    @Override
    public void destroy() {
        //do nothing
    }
}
