package cn.com.duibaboot.ext.autoconfigure.web.wrapper;


import cn.com.duiba.boot.exception.DuibaBootRuntimeException;
import org.apache.commons.io.IOUtils;

import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;

/**
 * 缓存请求的body
 * 解决request.getBody（）只能读取一次的问题
 */
public class BodyReaderHttpServletRequestWrapper extends HttpServletRequestWrapper {

    private final byte[] body;

    public BodyReaderHttpServletRequestWrapper(HttpServletRequest request){
        super(request);
        try{
            body = IOUtils.toByteArray(request.getInputStream());
        }catch (IOException e){
            throw new DuibaBootRuntimeException(e);
        }
    }

    @Override
    public ServletInputStream getInputStream(){
        return new BodyReaderServletInputStream(body);
    }

    @Override
    public BufferedReader getReader(){
        return new BufferedReader(new StringReader(getBody()));
    }

    public String getBody() {
        return new String(body,Charset.forName("utf-8"));
    }


    class BodyReaderServletInputStream extends ServletInputStream{

        private final ByteArrayInputStream byteArrayInputStream;


        BodyReaderServletInputStream(byte[] body){
            this.byteArrayInputStream = new ByteArrayInputStream(body);
        }

        @Override
        public boolean isFinished() {
            return false;
        }

        @Override
        public boolean isReady() {
            return false;
        }

        @Override
        public void setReadListener(ReadListener readListener) {
            //内容已经完整，不需要监听
        }

        @Override
        public int read(){
            return byteArrayInputStream.read();
        }
    }


}