/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.Ordered;

public class DuibaEurekaAutoServiceRegistration
implements SmartLifecycle,
ApplicationRunner,
Ordered {
    private static final Log log = LogFactory.getLog(DuibaEurekaAutoServiceRegistration.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private int order = 0;
    private AtomicInteger port = new AtomicInteger(0);
    private ApplicationContext context;
    private EurekaServiceRegistry serviceRegistry;
    private EurekaRegistration registration;

    public DuibaEurekaAutoServiceRegistration(ApplicationContext context, EurekaServiceRegistry serviceRegistry, EurekaRegistration registration) {
        this.context = context;
        this.serviceRegistry = serviceRegistry;
        this.registration = registration;
    }

    public void start() {
        if (this.port.get() != 0) {
            if (this.registration.getNonSecurePort() == 0) {
                this.registration.setNonSecurePort(this.port.get());
            }
            if (this.registration.getSecurePort() == 0 && this.registration.isSecure()) {
                this.registration.setSecurePort(this.port.get());
            }
        }
        if (!this.running.get() && this.registration.getNonSecurePort() > 0) {
            this.serviceRegistry.register(this.registration);
            this.context.publishEvent((ApplicationEvent)new InstanceRegisteredEvent((Object)this, (Object)this.registration.getInstanceConfig()));
            this.running.set(true);
        }
    }

    public void stop() {
        this.serviceRegistry.deregister(this.registration);
        this.running.set(false);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getOrder() {
        return this.order;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.start();
    }

    @EventListener(value={WebServerInitializedEvent.class})
    public void onApplicationEvent(WebServerInitializedEvent event) {
        int localPort = event.getWebServer().getPort();
        if (this.port.get() == 0) {
            log.info((Object)("Updating port to " + localPort));
            this.port.compareAndSet(0, localPort);
        }
    }

    @EventListener(value={ContextClosedEvent.class})
    public void onApplicationEvent(ContextClosedEvent event) {
        if (event.getApplicationContext() == this.context) {
            this.stop();
        }
    }
}

