/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;

public class EurekaClientBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(EurekaClientBeanDefinitionRegistryPostProcessor.class);
    private static final String EUREKA_CLIENT_BEAN_ID = "eurekaClient";

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        BeanDefinition eurekaClientBeanDefinition = null;
        BeanDefinition scopedEurekaClientBeanDefinition = null;
        try {
            eurekaClientBeanDefinition = registry.getBeanDefinition(EUREKA_CLIENT_BEAN_ID);
            scopedEurekaClientBeanDefinition = registry.getBeanDefinition("scopedTarget.eurekaClient");
        }
        catch (NoSuchBeanDefinitionException e) {
            return;
        }
        if (eurekaClientBeanDefinition == null || scopedEurekaClientBeanDefinition == null) {
            return;
        }
        BeanDefinition eurekaClientOriginatingBeanDefinition = eurekaClientBeanDefinition.getOriginatingBeanDefinition();
        if (eurekaClientOriginatingBeanDefinition == null) {
            throw new IllegalStateException("[NOTIFYME]\u5982\u679c\u4f60\u770b\u5230\u8fd9\u4e2a\u5f02\u5e38\uff0c\u8bf4\u660e\u6211\u4eec\u4e0d\u652f\u6301spring-cloud\u6216spring-boot\u7684\u65b0\u7248\u672c\uff0c\u8bf7\u8054\u7cfb\u4e2d\u95f4\u4ef6\u56e2\u961f\u89e3\u51b3\u6b64\u95ee\u9898");
        }
        registry.removeBeanDefinition("scopedTarget.eurekaClient");
        eurekaClientOriginatingBeanDefinition.setAutowireCandidate(true);
        eurekaClientOriginatingBeanDefinition.setScope("singleton");
        registry.removeBeanDefinition(EUREKA_CLIENT_BEAN_ID);
        registry.registerBeanDefinition(EUREKA_CLIENT_BEAN_ID, eurekaClientOriginatingBeanDefinition);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

