/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.AopTargetUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.ILoadBalancer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={EurekaClient.class})
public class EurekaClientPushAutoConfiguration {
    private static final String SSE_PREFIX = "data:";
    public static final String EUREKA_COMMAND_REFRESH = "refresh";
    private static final Logger logger = LoggerFactory.getLogger(EurekaClientPushAutoConfiguration.class);
    @Resource(name="eurekaClient")
    private EurekaClient eurekaClient;
    @Value(value="${spring.application.name}")
    private String currentAppName;
    @Resource
    private SpringClientFactory ribbonSpringClientFactory;
    @Resource
    private CloseableHttpClient apacheHttpClient;
    private volatile String relyAppNames;
    private int continuousIoExceptionTimes;
    private Thread eurekaClientPushThread = new Thread("eurekaClientPushThread"){

        @Override
        public void run() {
            do {
                try {
                    while (true) {
                        EurekaClientPushAutoConfiguration.this.refreshRelyAppNames();
                        if (!StringUtils.isBlank((CharSequence)EurekaClientPushAutoConfiguration.this.relyAppNames)) break;
                        Thread.sleep(60000L);
                    }
                    boolean isContinue = EurekaClientPushAutoConfiguration.this.connectEurekaServerSse();
                    if (isContinue) continue;
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    logger.error("\u5904\u7406eureka sse\u5931\u8d25", (Throwable)e);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
            } while (!Thread.currentThread().isInterrupted());
        }
    };

    @EventListener(value={MainContextRefreshedEvent.class})
    public void onMainContextRefreshed() {
        this.eurekaClientPushThread.start();
    }

    private void refreshRelyAppNames() {
        Set relyAppNameSet = this.ribbonSpringClientFactory.getContextNames();
        ArrayList tempList = new ArrayList(relyAppNameSet);
        tempList.remove(this.currentAppName);
        tempList.remove("not-exists");
        Collections.sort(tempList);
        this.relyAppNames = Joiner.on((String)",").join(tempList);
    }

    @PreDestroy
    public void destroy() {
        this.eurekaClientPushThread.interrupt();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean connectEurekaServerSse() throws Exception {
        String oneEurekaServerUrl = this.getRandomEurekaServerUrl();
        if (oneEurekaServerUrl == null) {
            logger.info("eureka server urls is not exists, will not push eureka's registry");
            return false;
        }
        oneEurekaServerUrl = oneEurekaServerUrl.substring(0, oneEurekaServerUrl.lastIndexOf("/eureka")) + "/sse/eureka";
        HttpPost req = new HttpPost(oneEurekaServerUrl);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("appName", this.currentAppName), new BasicNameValuePair("dependentAppNames", this.relyAppNames)));
        req.setEntity((HttpEntity)entity);
        try (CloseableHttpResponse resp = this.apacheHttpClient.execute((HttpUriRequest)req);){
            if (!(resp.getEntity() == null || resp.getEntity().getContentType() == null || resp.getEntity().getContentType().getValue() == null || resp.getStatusLine().getStatusCode() != 404 && resp.getEntity().getContentType().getValue().startsWith("text/event-stream"))) {
                logger.info("eurekaServer \u4e0d\u652f\u6301SSE push");
                Thread.sleep(60000L);
                boolean bl = true;
                return bl;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
            byte[] bs = new byte[1024];
            while (true) {
                int length;
                if ((length = resp.getEntity().getContent().read(bs)) == -1) {
                    this.continuousIoExceptionTimes = 0;
                    return true;
                }
                if (length <= 0) continue;
                buffer.write(bs, 0, length);
                buffer = this.consumeBuffer(buffer);
            }
        }
        catch (IOException e) {
            logger.info("\u8fde\u63a5eurekaServer\u5931\u8d25\uff0c\u5c06\u4f1a\u91cd\u8bd5:{}", (Object)e.getMessage());
            if (this.continuousIoExceptionTimes++ < 5) return true;
            Thread.sleep(10000L);
        }
        return true;
    }

    private ByteArrayOutputStream consumeBuffer(ByteArrayOutputStream buffer) throws Exception {
        List<String> sseDataLines = this.getSseDateLines(buffer);
        HashSet<String> appNamesToRefresh = new HashSet<String>();
        for (String sseDataLine : sseDataLines) {
            if (sseDataLine.startsWith(SSE_PREFIX)) {
                String jsonData = sseDataLine.substring(SSE_PREFIX.length(), sseDataLine.length() - 2);
                JSONObject jsonObject = JSON.parseObject((String)jsonData);
                if (!EUREKA_COMMAND_REFRESH.equals(jsonObject.getString("command"))) continue;
                String appNames = jsonObject.getString("appNames");
                appNamesToRefresh.addAll(Arrays.asList(appNames.split(",")));
                continue;
            }
            logger.warn("[NOTIFYME]invalid data,ignore it:{}", (Object)sseDataLine);
        }
        if (!appNamesToRefresh.isEmpty()) {
            logger.info("notifyRefreshEureka: {}", appNamesToRefresh);
            this.notifyRefreshEureka(appNamesToRefresh);
        }
        return buffer;
    }

    private List<String> getSseDateLines(ByteArrayOutputStream buffer) {
        ArrayList<String> sseDataLines = new ArrayList<String>();
        boolean isAllDataLinesFetched = false;
        block0: while (!isAllDataLinesFetched && buffer.size() > 1) {
            byte[] allBs = buffer.toByteArray();
            for (int i = 0; i < allBs.length - 1; ++i) {
                if (allBs[i] == 10 && i < allBs.length - 1 && allBs[i + 1] == 10) {
                    String sseDataLine = new String(allBs, 0, i + 2);
                    sseDataLines.add(sseDataLine);
                    buffer.reset();
                    buffer.write(allBs, i + 2, allBs.length - (i + 2));
                    continue block0;
                }
                if (i < allBs.length - 2) continue;
                isAllDataLinesFetched = true;
                continue block0;
            }
        }
        return sseDataLines;
    }

    private void notifyRefreshEureka(Set<String> appNamesToRefresh) throws Exception {
        Method method = ReflectionUtils.findMethod(DiscoveryClient.class, (String)"refreshRegistry");
        method.setAccessible(true);
        DiscoveryClient discoveryClient = (DiscoveryClient)AopTargetUtils.getTarget((Object)this.eurekaClient);
        ReflectionUtils.invokeMethod((Method)method, (Object)discoveryClient);
        for (String serviceId : this.ribbonSpringClientFactory.getContextNames()) {
            ILoadBalancer loadBalancer;
            if (!appNamesToRefresh.contains(serviceId.toUpperCase()) || !((loadBalancer = (ILoadBalancer)this.ribbonSpringClientFactory.getInstance(serviceId, ILoadBalancer.class)) instanceof DynamicServerListLoadBalancer)) continue;
            ((DynamicServerListLoadBalancer)loadBalancer).updateListOfServers();
        }
    }

    private String getRandomEurekaServerUrl() {
        List eurekaServerUrls = this.eurekaClient.getEurekaClientConfig().getEurekaServerServiceUrls("defaultZone");
        if (eurekaServerUrls == null || eurekaServerUrls.isEmpty()) {
            return null;
        }
        return (String)eurekaServerUrls.get(RandomUtils.nextInt((int)0, (int)eurekaServerUrls.size()));
    }
}

