/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.PropertyResolver;
import cn.com.duibaboot.ext.autoconfigure.datasource.DataSourceBeanDefinitionRegistryPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.datasource.DuibaDataSourceEndpoint;
import cn.com.duibaboot.ext.autoconfigure.datasource.DuibaDataSourceMonitor;
import cn.com.duibaboot.ext.autoconfigure.datasource.DuibaDataSourceProperties;
import java.util.HashSet;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

@Configuration
@ConditionalOnClass(value={DataSource.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class DuibaDataSourceAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DuibaDataSourceAutoConfiguration.class);
    @Resource
    private ApplicationContext applicationContext;

    @EventListener(value={EnvironmentChangeEvent.class})
    public void onEvent(EnvironmentChangeEvent e) {
        String prefix = "duiba.datasource.";
        HashSet<String> dataSourceNamesNeedChange = new HashSet<String>();
        for (String key : e.getKeys()) {
            if (key == null || !key.startsWith(prefix)) continue;
            String dataSourceName = key.substring(prefix.length());
            dataSourceName = dataSourceName.substring(0, dataSourceName.indexOf(46));
            dataSourceNamesNeedChange.add(dataSourceName);
        }
        for (String dataSourceName : dataSourceNamesNeedChange) {
            DataSource ds;
            String dataSourceBeanName = DataSourceBeanDefinitionRegistryPostProcessor.normalizationDataSourceName(dataSourceName);
            try {
                ds = (DataSource)this.applicationContext.getBean(dataSourceBeanName, DataSource.class);
            }
            catch (NoSuchBeanDefinitionException e1) {
                logger.warn("refresh datasource \u65f6\u627e\u4e0d\u5230\u540d\u4e3a\uff1a" + dataSourceBeanName + "\u7684bean\uff0c\u4e0d\u652f\u6301\u8fd0\u884c\u65f6\u6dfb\u52a0\u6570\u636e\u6e90\uff0c\u5982\u9700\u6dfb\u52a0\u6570\u636e\u6e90\uff0c\u8bf7\u91cd\u542f", (Throwable)e1);
                continue;
            }
            catch (BeanNotOfRequiredTypeException e2) {
                logger.warn("refresh datasource \u65f6\u540d\u4e3a\uff1a" + dataSourceBeanName + "\u7684bean\u4e0d\u662fDataSource\u7c7b\u578b\uff0c\u800c\u662f\uff1a" + e2.getActualType().getName() + "\u7c7b\u578b\uff0c\u4e0d\u652f\u6301refresh.", (Throwable)e2);
                continue;
            }
            PropertyResolver resolver = new PropertyResolver((AbstractEnvironment)this.applicationContext.getEnvironment(), prefix + dataSourceName);
            DuibaDataSourceProperties.DataSourcePropertiesInner props = resolver.bindToConfig(DuibaDataSourceProperties.DataSourcePropertiesInner.class);
            props.bindProperties(dataSourceBeanName, ds);
        }
    }

    @Configuration
    @ConditionalOnClass(value={BasicDataSource.class, AbstractRoutingDataSource.class})
    public static class DuibaDataSourceMonitorAutoConfiguration {
        @Bean
        public DuibaDataSourceMonitor _duibaDataSourceMonitor() {
            return new DuibaDataSourceMonitor();
        }

        @Bean
        public DuibaDataSourceEndpoint duibaDataSourceEndpoint() {
            return new DuibaDataSourceEndpoint();
        }

        @Bean
        public ApplicationListener duibaDataSourceMonitor(final DuibaDataSourceMonitor _duibaDataSourceMonitor) {
            return new ApplicationListener<MainContextRefreshedEvent>(){

                public void onApplicationEvent(MainContextRefreshedEvent mainContextRefreshedEvent) {
                    ApplicationContext context = mainContextRefreshedEvent.getApplicationContext();
                    _duibaDataSourceMonitor.startMonitorThread(context);
                }
            };
        }
    }

    @Configuration
    @ConditionalOnClass(value={BasicDataSource.class})
    public static class Dbcp2DataSourcePostProcessorConfiguration {
        @Bean
        public static SpecifiedBeanPostProcessor<BasicDataSource> basicDataSourcePostProcessor() {
            return new SpecifiedBeanPostProcessor<BasicDataSource>(){

                @Override
                public Class<BasicDataSource> getBeanType() {
                    return BasicDataSource.class;
                }

                @Override
                public Object postProcessBeforeInitialization(BasicDataSource bean, String beanName) throws BeansException {
                    return bean;
                }

                @Override
                public Object postProcessAfterInitialization(BasicDataSource bean, String beanName) throws BeansException {
                    bean.setRemoveAbandonedOnBorrow(true);
                    bean.setRemoveAbandonedOnMaintenance(true);
                    bean.setLogAbandoned(true);
                    bean.setTestOnBorrow(false);
                    if (bean.getTimeBetweenEvictionRunsMillis() == -1L) {
                        bean.setTimeBetweenEvictionRunsMillis(90000L);
                    }
                    if (bean.getMaxWaitMillis() == -1L) {
                        bean.setMaxWaitMillis(3000L);
                    }
                    bean.setMinEvictableIdleTimeMillis(600000L);
                    bean.setValidationQuery("/* ping */ SELECT 1");
                    bean.setTestWhileIdle(true);
                    return bean;
                }

                public int getOrder() {
                    return -100;
                }
            };
        }
    }
}

