/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dbexec;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.dbexec.ExecutableCommand;
import cn.com.duibaboot.ext.autoconfigure.dbexec.JvmIdTool;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@ControllerEndpoint(id="dbexec")
public class ExecMvcEndpoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecMvcEndpoint.class);
    private static final ExecutorService es = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("dbexec"));

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"}, value={"/{commandKey}"})
    public Flux<ServerSentEvent<String>> invoke(@PathVariable String commandKey) {
        if (StringUtils.isBlank((String)commandKey)) {
            throw new RuntimeException("commandKey \u4e0d\u80fd\u4e3a null");
        }
        if (!ExecutableCommand.contains(commandKey)) {
            throw new RuntimeException("\u975e\u6cd5\u7684 commandKey");
        }
        return this.buildSseEmitter(ExecutableCommand.get(commandKey));
    }

    private Flux<ServerSentEvent<String>> buildSseEmitter(ExecutableCommand executableCommand) {
        String command = this.renderCommand(executableCommand);
        return Flux.create(s -> {
            Process process;
            System.out.println(Thread.currentThread().getName());
            try {
                process = Runtime.getRuntime().exec(command);
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
                s.error((Throwable)e);
                return;
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
                 LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);){
                String line;
                while ((line = lineNumberReader.readLine()) != null) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("execReuslt", (Object)line);
                    s.next((Object)ServerSentEvent.builder().data((Object)jsonObject.toString()).build());
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                s.error((Throwable)e);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
                s.complete();
            }
        }).subscribeOn(Schedulers.fromExecutor((Executor)es));
    }

    private String renderCommand(ExecutableCommand commandEnum) {
        String command = commandEnum.getCommand();
        command = command.replace("${vmid}", JvmIdTool.getVmId());
        return command;
    }
}

