/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping.filter;

import cn.com.duibaboot.ext.autoconfigure.grouping.ReactiveServiceGroupUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Order(value=-2147483645)
public class ReactiveServiceGroupFilter
implements WebFilter {
    private static final Logger log = LoggerFactory.getLogger(ReactiveServiceGroupFilter.class);

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String groupKey = ReactiveServiceGroupUtils.getDuibaServiceGroupKey(exchange.getRequest());
        if (StringUtils.isNotBlank((CharSequence)groupKey)) {
            HashMap<String, String> loadBalancerInfo = (HashMap<String, String>)exchange.getAttribute("_loadBalancerKeyAttr");
            if (loadBalancerInfo == null) {
                loadBalancerInfo = new HashMap<String, String>();
                exchange.getAttributes().put("_loadBalancerKeyAttr", loadBalancerInfo);
            }
            loadBalancerInfo.put("_duibaServiceGroupKey", groupKey);
        }
        return chain.filter(exchange);
    }
}

