/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.httpclient;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;

public class HttpAsyncClientWrapper
extends CloseableHttpAsyncClient {
    private CloseableHttpAsyncClient original;

    public HttpAsyncClientWrapper(CloseableHttpAsyncClient original) {
        this.original = original;
    }

    private <T> FutureCallback<T> getPerfTestWrappedCallback(final FutureCallback<T> callback) {
        final boolean isCurrentInPerfTestMode = InternalPerfTestContext.isCurrentInPerfTestMode();
        final String currentPerfTestSceneId = InternalPerfTestContext.getCurrentSceneId();
        FutureCallback wrappedCallback = new FutureCallback<T>(){

            public void completed(T result) {
                if (isCurrentInPerfTestMode) {
                    InternalPerfTestContext.markAsPerfTest((String)currentPerfTestSceneId);
                } else {
                    InternalPerfTestContext.markAsNormal();
                }
                try {
                    callback.completed(result);
                }
                finally {
                    InternalPerfTestContext.markAsNormal();
                }
            }

            public void failed(Exception ex) {
                if (isCurrentInPerfTestMode) {
                    InternalPerfTestContext.markAsPerfTest((String)currentPerfTestSceneId);
                } else {
                    InternalPerfTestContext.markAsNormal();
                }
                try {
                    callback.failed(ex);
                }
                finally {
                    InternalPerfTestContext.markAsNormal();
                }
            }

            public void cancelled() {
                if (isCurrentInPerfTestMode) {
                    InternalPerfTestContext.markAsPerfTest((String)currentPerfTestSceneId);
                } else {
                    InternalPerfTestContext.markAsNormal();
                }
                try {
                    callback.cancelled();
                }
                finally {
                    InternalPerfTestContext.markAsNormal();
                }
            }
        };
        return wrappedCallback;
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        return this.original.execute(requestProducer, responseConsumer, context, this.getPerfTestWrappedCallback(callback));
    }

    public boolean isRunning() {
        return this.original.isRunning();
    }

    public void start() {
        this.original.start();
    }

    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, FutureCallback<T> callback) {
        return this.original.execute(requestProducer, responseConsumer, this.getPerfTestWrappedCallback(callback));
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.original.execute(target, request, context, this.getPerfTestWrappedCallback(callback));
    }

    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, FutureCallback<HttpResponse> callback) {
        return this.original.execute(target, request, this.getPerfTestWrappedCallback(callback));
    }

    public Future<HttpResponse> execute(HttpUriRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        return this.original.execute(request, context, this.getPerfTestWrappedCallback(callback));
    }

    public Future<HttpResponse> execute(HttpUriRequest request, FutureCallback<HttpResponse> callback) {
        return this.original.execute(request, this.getPerfTestWrappedCallback(callback));
    }

    public void close() throws IOException {
        this.original.close();
    }
}

