/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security;

import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import cn.com.duibaboot.ext.autoconfigure.security.SecurityProperties;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.sql.SQLPermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.LoggingPermission;
import javax.annotation.PostConstruct;
import javax.security.auth.AuthPermission;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

@Configuration
@ConditionalOnProperty(name={"duiba.securitymanager.enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SecurityProperties.class})
public class SecurityManagerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SecurityManagerAutoConfiguration.class);
    static Set<String> forbiddenPermNames = new HashSet<String>(10);
    @Autowired
    private SecurityProperties securityProperties;
    private Set<String> whiteShells = new HashSet<String>();

    @PostConstruct
    public void init() {
        this.whiteShells.addAll(Arrays.asList("/usr/bin/id", "/bin/id", "id", "/usr/xpg4/bin/id", "setsid", "jstat", "jmap"));
        String[] forbiddenShells = new String[]{"sh", "bash", "source", "exec", "fork"};
        String str = this.securityProperties.getWhiteShellList();
        String[] arr = StringUtils.split((String)str, (char)',');
        if (arr == null) {
            return;
        }
        for (String shell : arr) {
            if (this.isForbiddenShell(shell, forbiddenShells)) {
                logger.warn("\u4f60\u8bbe\u7f6e\u7684shell\u767d\u540d\u5355(duiba.securitymanager.whiteShellList)\u4e2d\u5305\u542b\u8fc7\u4e8e\u5371\u9669\u7684shell\uff1a`{}`, \u5df2\u6392\u9664.", (Object)shell);
                continue;
            }
            this.whiteShells.add(shell);
        }
    }

    private boolean isForbiddenShell(String shell, String[] forbiddenShells) {
        for (String forbiddenShell : forbiddenShells) {
            if (!forbiddenShell.equalsIgnoreCase(shell)) continue;
            return true;
        }
        return false;
    }

    private static boolean conditionalOnMissingClass(String ... classNames) {
        boolean existsOne = false;
        for (String className : classNames) {
            try {
                Class.forName(className);
                existsOne = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return !existsOne;
    }

    @Bean
    public DuibaSecurityManagerConfiguarApplicationListener duibaSecurityManagerConfiguarApplicationListener() {
        return new DuibaSecurityManagerConfiguarApplicationListener();
    }

    static {
        forbiddenPermNames.add("queuePrintJob");
        if (!SpringBootUtils.isUnitTestMode()) {
            forbiddenPermNames.add("setIO");
            forbiddenPermNames.add("setSecurityManager");
        }
    }

    class CustomSecurityManager
    extends SecurityManager {
        CustomSecurityManager() {
        }

        private boolean isInWhiteShellList(String cmd) {
            return SecurityManagerAutoConfiguration.this.whiteShells.contains(cmd);
        }

        @Override
        public void checkExec(String cmd) {
            if (this.isInWhiteShellList(cmd)) {
                return;
            }
            try {
                super.checkExec(cmd);
            }
            catch (AccessControlException e) {
                logger.warn("some one try to execute shell:`{}`, block it", (Object)cmd);
                throw e;
            }
        }

        @Override
        public void checkCreateClassLoader() {
        }

        @Override
        public void checkRead(String file) {
        }

        @Override
        public void checkRead(String file, Object context) {
        }

        @Override
        public void checkWrite(String file) {
        }

        @Override
        public void checkDelete(String file) {
        }

        @Override
        public void checkPackageAccess(String pkg) {
        }

        @Override
        public void checkAccess(Thread t) {
        }

        @Override
        public void checkAccess(ThreadGroup g) {
        }

        public void checkMemberAccess(Class<?> clazz, int which) {
            String className = clazz.getName();
            if (className.equals("java.lang.ProcessImpl") || className.equals("java.lang.UNIXProcess") || className.equals("java.lang.ProcessBuilder")) {
                throw new AccessControlException("not allowed to reflect access class:" + className);
            }
        }

        @Override
        public void checkPermission(Permission perm) {
            FilePermission fp;
            if (perm.getName().equals("getClassLoader") || perm.getName().equals("getProtectionDomain") || perm.getName().equals("accessDeclaredMembers") || perm.getName().equals("<all permissions>") || perm.getClass().getName().equals("java.lang.RuntimePermission")) {
                return;
            }
            if (perm.getClass().getName().equals("java.io.FilePermission") && (fp = (FilePermission)perm).getActions().equals("execute")) {
                super.checkPermission(perm);
                return;
            }
            if (perm instanceof AllPermission || perm instanceof PropertyPermission || perm instanceof SerializablePermission || perm instanceof ReflectPermission || perm instanceof NetPermission || perm instanceof SQLPermission || perm instanceof SecurityPermission || perm instanceof LoggingPermission || perm instanceof AuthPermission || perm instanceof SocketPermission) {
                return;
            }
            if (forbiddenPermNames.contains(perm.getName())) {
                super.checkPermission(perm);
                return;
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
        }

        @Override
        public void checkExit(int status) {
        }

        @Override
        public void checkLink(String lib) {
        }

        @Override
        public void checkRead(FileDescriptor fd) {
        }

        @Override
        public void checkWrite(FileDescriptor fd) {
        }

        @Override
        public void checkConnect(String host, int port) {
        }

        @Override
        public void checkConnect(String host, int port, Object context) {
        }

        @Override
        public void checkListen(int port) {
        }

        @Override
        public void checkAccept(String host, int port) {
        }

        @Override
        public void checkMulticast(InetAddress maddr) {
        }

        @Override
        public void checkMulticast(InetAddress maddr, byte ttl) {
        }

        @Override
        public void checkPropertiesAccess() {
        }

        @Override
        public void checkPropertyAccess(String key) {
        }

        @Override
        public void checkPackageDefinition(String pkg) {
        }

        @Override
        public void checkSetFactory() {
        }

        @Override
        public void checkSecurityAccess(String target) {
        }
    }

    class DuibaSecurityManagerConfiguarApplicationListener
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        private boolean flag = true;

        DuibaSecurityManagerConfiguarApplicationListener() {
        }

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (!this.flag) {
                return;
            }
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new CustomSecurityManager());
            }
            this.flag = false;
        }

        public int getOrder() {
            return -10;
        }
    }
}

