/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.pool;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.utils.AopTargetUtils;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.AbstractConnPool;
import org.apache.http.pool.PoolEntry;
import org.apache.http.pool.RouteSpecificPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class LeastActiveServerListFilter
implements RibbonServerListFilter {
    private static final Logger logger = LoggerFactory.getLogger(LeastActiveServerListFilter.class);
    private Map<HttpRoute, RouteSpecificPool<HttpRoute, ManagedHttpClientConnection, PoolEntry<HttpRoute, ManagedHttpClientConnection>>> routeToPool;
    private AtomicLong count = new AtomicLong();
    private static final String DUIBA_RIBBON_LOADBANCE_TYPE_KEY = "duiba.ribbon.loadbalance.type";
    private static final String DUIBA_RIBBON_LOADBANCE_TYPE_LEAST_ACTIVE = "leastactive";
    @Value(value="${duiba.ribbon.loadbalance.type:}")
    private volatile String loadBalanceType;

    @EventListener(classes={EnvironmentChangeEvent.class})
    public void onEnvRefreshed(EnvironmentChangeEvent event) {
        this.loadBalanceType = ((ConfigurableApplicationContext)event.getSource()).getEnvironment().getProperty(DUIBA_RIBBON_LOADBANCE_TYPE_KEY);
    }

    @Resource
    public void setApacheHttpClient(HttpClient apacheHttpClient) throws Exception {
        Map routeToPool;
        apacheHttpClient = (HttpClient)AopTargetUtils.getTarget((Object)apacheHttpClient);
        Field field = apacheHttpClient.getClass().getDeclaredField("connManager");
        field.setAccessible(true);
        PoolingHttpClientConnectionManager cm = (PoolingHttpClientConnectionManager)field.get(apacheHttpClient);
        field = cm.getClass().getDeclaredField("pool");
        field.setAccessible(true);
        AbstractConnPool pool = (AbstractConnPool)field.get(cm);
        field = AbstractConnPool.class.getDeclaredField("routeToPool");
        field.setAccessible(true);
        this.routeToPool = routeToPool = (Map)field.get(pool);
    }

    public List<Server> filter(List<Server> serverList, Object key) {
        if (!StringUtils.equals((String)this.loadBalanceType, (String)DUIBA_RIBBON_LOADBANCE_TYPE_LEAST_ACTIVE)) {
            return serverList;
        }
        if (serverList.isEmpty() || !(serverList.get(0) instanceof DiscoveryEnabledServer)) {
            return serverList;
        }
        ArrayList<Server> servers = new ArrayList<Server>(serverList);
        ArrayList<Integer> leaseList = new ArrayList<Integer>();
        for (Server server : servers) {
            int port;
            String host = ((DiscoveryEnabledServer)server).getInstanceInfo().getIPAddr();
            RouteSpecificPool<HttpRoute, ManagedHttpClientConnection, PoolEntry<HttpRoute, ManagedHttpClientConnection>> val = this.routeToPool.get(new HttpRoute(new HttpHost(host, port = ((DiscoveryEnabledServer)server).getInstanceInfo().getPort(), "http")));
            if (val != null) {
                leaseList.add(val.getLeasedCount());
                continue;
            }
            leaseList.add(0);
        }
        int totalLeased = 0;
        for (Integer leased : leaseList) {
            totalLeased += leased.intValue();
        }
        float f = (float)totalLeased * 1.0f / (float)leaseList.size();
        for (int i = leaseList.size() - 1; i >= 0; --i) {
            Integer leased = (Integer)leaseList.get(i);
            if (!((float)leased.intValue() > f) || leased <= 5) continue;
            servers.remove(i);
        }
        if (servers.isEmpty()) {
            return serverList;
        }
        return servers;
    }
}

