package cn.com.duibaboot.ext.autoconfigure.cat;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import brave.ErrorParser;
import brave.Span;
import brave.Tracer;
import zipkin2.Endpoint;

@Aspect
public class SleuthRedisPlugin {

	@Autowired
	private Tracer tracer;
	@Autowired
	private ErrorParser errorParser;
	
	@Around("execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
	public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable{
		Span curSpan = tracer.currentSpan();
		if(curSpan == null || curSpan.isNoop()){
			return joinPoint.proceed();
		}

		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		String methodName = signature.getMethod().getName();

		Span span = tracer.nextSpan().name("redis:/"+methodName).kind(Span.Kind.CLIENT)
				.remoteEndpoint(Endpoint.newBuilder().serviceName("redis").build())
				.start();
		try {
			span.tag("redis.op", methodName);// get/...
			span.tag("lc", "redisClient");//本地组件名
//            span.tag("peer.host", "www.duiba.com.cn:3306");//远程host
			if("get".equals(methodName)
					&& joinPoint.getArgs() != null
					&& joinPoint.getArgs().length == 1
					&& joinPoint.getArgs()[0] != null){
				span.tag("redis.key", joinPoint.getArgs()[0].toString());//key
			}
//			span.logEvent(Span.CLIENT_SEND);

			return joinPoint.proceed();
		} catch(Exception e){
			errorParser.error(e, span);
			throw e;
		} finally {
//			span.logEvent(Span.CLIENT_RECV);
			span.finish();
		}
	}
	
}
