package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.netflix.ribbon.*;

/**
 * 这个自定义类的目的主要是为了增加带loadBalancerKey的choose方法, spring默认提供的choose方法不能带上loadBalancerKey，无法传递压测、服务分组等相关信息。
 */
public class CustomRibbonLoadBalancerClient extends RibbonLoadBalancerClient {
    private SpringClientFactory clientFactory;

    public CustomRibbonLoadBalancerClient(SpringClientFactory clientFactory) {
        super(clientFactory);
        this.clientFactory = clientFactory;
    }

    /**
     * 这个自定义类的目的主要是为了增加这个带loadBalancerKey的方法,spring默认提供的choose方法不能带上loadBalancerKey，无法传递压测、服务分组等相关信息。
     * <br/>
     * 根据服务名和loadBalancerKey获取一个服务器
     *
     * @param serviceId
     * @param loadBalancerKey
     * @return
     */
    public ServiceInstance choose(String serviceId, Object loadBalancerKey) {
        ILoadBalancer loadBalancer = getLoadBalancer(serviceId);
        if (loadBalancer == null) {
            return null;
        }
        Server server = loadBalancer.chooseServer(loadBalancerKey);
        if (server == null) {
            return null;
        }
        return new RibbonServer(serviceId, server, isSecure(server, serviceId),
                serverIntrospector(serviceId).getMetadata(server));
    }

    //copy from super
    private boolean isSecure(Server server, String serviceId) {
        IClientConfig config = this.clientFactory.getClientConfig(serviceId);
        ServerIntrospector serverIntrospector = serverIntrospector(serviceId);
        return RibbonUtils.isSecure(config, serverIntrospector, server);
    }

    //copy from super
    private ServerIntrospector serverIntrospector(String serviceId) {
        ServerIntrospector serverIntrospector = this.clientFactory.getInstance(serviceId,
                ServerIntrospector.class);
        if (serverIntrospector == null) {
            serverIntrospector = new DefaultServerIntrospector();
        }
        return serverIntrospector;
    }

}
