package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;

import java.lang.reflect.Method;

/**
 * 引流回归的机器不应当执行job，所以启动的时候，不把自己注册到elasticjob的zk上
 * Created by guoyanfei .
 * 2019-09-06 .
 */
public class DisableElasticJobMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if ("init".equals(method.getName()) && FlowReplayUtils.isReplayEnv()) {
            result.defineReturnValue(null);
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        // do nothing
    }
}
