package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 流量录制配置的实体类
 * Created by guoyanfei .
 * 2019-01-23 .
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class RecordConfigDto implements Serializable {

    private static final long serialVersionUID = -4778640379274477988L;

    /**
     * 用例集id
     */
    private Long usecaseSetId;

    /**
     * 录制文件最大大小，单位M
     */
    private Integer maxFileSize;

    /**
     * 录制文件最大分钟数，单位分钟
     */
    private Integer maxMinutes;

    /**
     * 采样率
     */
    private Float samplerPercentage;

    /**
     * 堆栈节点的前缀白名单
     * 每个span都有自己的调用链堆栈，其中很多内容是开发不需要关心的。
     * 一般情况下，开发关心的都是公司内部的一些包下面的调用
     * 比如 cn.com.duiba / cn.tuia 等等开头的行
     * 这个白名单的功能就是维护了公司内部的一些包的开头，用来过滤出开发需要关心的堆栈
     */
    private List<String> stackFramesPrefixWhitelist;

    /**
     * 参数是否合法
     * @return
     */
    public boolean isLegal() {
        return usecaseSetId != null && maxFileSize != null && maxMinutes != null;
    }

    @Override
    public String toString() {
        return "FlowRecordConfigDto{" + "usecaseSetId=" + usecaseSetId + ", maxFileSize=" + maxFileSize + ", maxMinutes=" + maxMinutes + '}';
    }
}
