package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.sampler.PercentageBasedRecordSampler;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;

/**
 * 流量录制开始
 */
@Endpoint(id="flow-record")
public class RecordMvcEndpoint {

    @Resource
    private PercentageBasedRecordSampler percentageBasedRecordSampler;

    @WriteOperation
    public String invoke(@RequestBody RecordConfigDto recordConfig) {
        JsonResult<String> result;
        try {
            // 开始录制
            RecordContextHolder.start(recordConfig);
            percentageBasedRecordSampler.init(recordConfig.getSamplerPercentage(), RecordContextHolder.getStartTime());
            result = JsonResult.successResult("ok");
        } catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
