package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import lombok.Data;

import java.io.Serializable;

/**
 * 回放单个trace的结果
 * Created by guoyanfei .
 * 2019-03-13 .
 */
@Data
public class ReplayTraceResult implements Serializable {

    private static final long serialVersionUID = 7099777871469745441L;

    private String traceId;

    private FlowReplaySpan mainSpan;

    /**
     * 回放成功
     */
    private boolean success;

    private String errorMsg;

    private String errorMsgDetail;

    /**
     * 返回值
     * 回放成功才会有
     * remoteService: 具体的类的对象
     * http: byte[] responseBody
     */
    private Object returnValue;

    /**
     * 回放详情的traceId
     * 不需要序列化
     */
    private transient FlowReplayTrace replayDetailTrace;

    public static ReplayTraceResult successResult(FlowReplayTrace trace, FlowReplayTrace replayDetailTrace, Object returnValue) {
        ReplayTraceResult result = new ReplayTraceResult();
        result.traceId = trace.getTraceId();
        result.mainSpan = trace.getMainSpan();
        result.success = true;
        result.errorMsg = null;
        result.returnValue = returnValue;
        result.replayDetailTrace = replayDetailTrace;
        return result;
    }

    public static ReplayTraceResult failResult(FlowReplayTrace trace,FlowReplayTrace replayDetailTrace, FlowReplayErrorMsgTypeEnum errorMsgType) {
        return failResult(trace, replayDetailTrace, errorMsgType, null);
    }

    public static ReplayTraceResult failResult(FlowReplayTrace trace, FlowReplayTrace replayDetailTrace, FlowReplayErrorMsgTypeEnum errorMsgType, String detail) {
        ReplayTraceResult result = new ReplayTraceResult();
        result.traceId = trace.getTraceId();
        result.mainSpan = trace.getMainSpan();
        result.success = false;
        result.errorMsg = errorMsgType.desc();
        result.errorMsgDetail = detail;
        result.returnValue = null;
        result.replayDetailTrace = replayDetailTrace;
        return result;
    }

}
