package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.FlowReplayTraceMapHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.ReplayTraceContextMapHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.SpringMvcReplayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpringMvcFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.web.wrapper.BodyReaderHttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * Spring Mvc 回放的过滤器。用于设置回放的trace上下文
 * Created by guoyanfei .
 * 2019-03-14 .
 */
public class ReplaySpringMvcFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        String traceId = req.getHeader(SpringMvcReplayer.TRACE_ID);
        BodyReaderHttpServletRequestWrapper requestWrapper = null;
        if (FlowReplayUtils.isReplayEnv() && StringUtils.isNotBlank(traceId)) {
            FlowReplayTrace trace = FlowReplayTraceMapHolder.getAndRemove(traceId);
            if (trace != null) {
                requestWrapper = new BodyReaderHttpServletRequestWrapper(req);
                // 创建回放详情trace(等同一次录制)
                FlowReplayTrace.cleanRecordEnv();
                SpringMvcFlowReplaySpan mainSpan = SpringMvcFlowReplaySpan.createSpan(requestWrapper);
                FlowReplayTrace.createReplayTrace(mainSpan, trace.getTraceId());
                mainSpan.setTraceId(trace.getTraceId());
                mainSpan.setSpanId(trace.getMainSpan().getSpanId());   // 把自动生成的spanId用之前录制的spanId覆盖掉

                // 创建回放trace上下文
                ReplayTraceContext.create(trace, FlowReplayTrace.get());
            }
        }

        try {
            chain.doFilter(requestWrapper == null ? req : requestWrapper, response);
        } finally {
            ReplayTraceContext context = ReplayTraceContext.getAndRemove();
            if (context != null) {
                DBTimeProfile.setCurrentThreshold(FlowReplayConstants.DB_TIME_PROFILE_THRESHOLD);
                ReplayTraceContextMapHolder.put(context);
            }
        }
    }

    @Override
    public void destroy() {
        // do nothing
    }
}
