package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import lombok.extern.slf4j.Slf4j;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.web.bind.annotation.RequestBody;

import java.io.IOException;

/**
 * 流量回放开始
 * Created by guoyanfei .
 * 2019-02-19 .
 */
@Slf4j
@Endpoint(id="flow-replay")
public class ReplayMvcEndpoint {

    @WriteOperation
    public String invoke(@RequestBody ReplayConfigDto replayConfig) throws IOException {
        JsonResult<String> result;
        try {
            if (!FlowReplayUtils.isReplayEnv()) {
                throw new FlowReplayException("当前服务非回放专用服务，无法进行回放相关操作");
            }
            // TODO 以下代码暂时注释掉，等测试稳定之后再放开，不然测试麻烦
//            if (!FlowReplayUtils.isReportIdValid(replayConfig.getReportId())) {
//                throw new FlowReplayException("回放报告ID不合法");
//            }
            ReplayContextHolder.start(replayConfig);
            result = JsonResult.successResult(ReplayContextHolder.debugInfo());
        } catch (FlowReplayException e) {
            result = JsonResult.failedResult(e.getMessage());
        } catch (Exception e) {
            log.error("回放start异常", e);
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
