package cn.com.duibaboot.ext.autoconfigure.perftest.lettuce;

import cn.com.duiba.boot.perftest.InternalPerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Method;

/**
 * 拦截lettuce操作，如果是发送消息(publish)则发送到特殊channel中，以防影响正常逻辑。
 */
@Slf4j
public class LettucePublishMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (InternalPerfTestContext.isCurrentInPerfTestMode()) {
            if (method.getName().equals("publish")) {//压测消息发送到特殊的名为PerfTest的channel中（因为redis的消息发送和订阅会无视dbIndex标志）
                if(allArguments[0] instanceof byte[]){
                    allArguments[0]="PerfTest".getBytes();
                }else if(allArguments[0] instanceof String){
                    allArguments[0]="PerfTest";
                }else{
                    log.warn("lettuce' publish uses:{}, should not be here", allArguments[0].getClass().getName(), new IllegalStateException());
                }
            }
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
