/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DuibaEurekaAutoServiceRegistration;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.EurekaClientBeanDefinitionRegistryPostProcessor;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.discovery.EurekaClient;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaAutoServiceRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
@ConditionalOnClass(value={EurekaAutoServiceRegistration.class})
public class EurekaClientPostProcessorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EurekaClientPostProcessorAutoConfiguration.class);
    @Autowired(required=false)
    private EurekaAutoServiceRegistration autoRegistration;
    @Autowired(required=false)
    private EurekaClient eurekaClient;

    @Bean
    public static EurekaClientBeanDefinitionRegistryPostProcessor eurekaClientBeanDefinitionRegistryPostProcessor() {
        return new EurekaClientBeanDefinitionRegistryPostProcessor();
    }

    @Bean
    public EurekaRegistration eurekaRegistration(EurekaClient eurekaClient, CloudEurekaInstanceConfig instanceConfig, ApplicationInfoManager applicationInfoManager, @Autowired(required=false) ObjectProvider<HealthCheckHandler> healthCheckHandler) {
        return EurekaRegistration.builder((CloudEurekaInstanceConfig)instanceConfig).with(applicationInfoManager).with(eurekaClient).with(healthCheckHandler).build();
    }

    @Bean
    public static DuibaEurekaAutoServiceRegistration duibaEurekaAutoServiceRegistration(ApplicationContext context, EurekaServiceRegistry registry, EurekaRegistration registration) {
        return new DuibaEurekaAutoServiceRegistration(context, registry, registration);
    }

    @EventListener(value={InstanceRegisteredEvent.class})
    public void onEureuaRegistered(InstanceRegisteredEvent e) {
        log.info("\u5f53\u524d\u5b9e\u4f8b\u5df2\u7ecf\u6210\u529f\u6ce8\u518c\u5230eureka");
    }

    @PostConstruct
    public void init() {
        if (this.autoRegistration != null) {
            throw new IllegalStateException("\u8bf7\u5173\u95edspring-cloud\u5b98\u65b9\u7684\u81ea\u52a8\u6ce8\u518c\u529f\u80fd\uff0c\u9ed8\u8ba4\u60c5\u51b5\u4e0b\u6211\u4eec\u4f1a\u6dfb\u52a0\u9ed8\u8ba4\u914d\u7f6e\uff1aspring.cloud.service-registry.auto-registration.enabled=false\u6765\u5173\u95ed\u8be5\u529f\u80fd\uff0c\u8bf7\u68c0\u67e5\u4f60\u662f\u5426\u81ea\u5df1\u8bbe\u7f6e\u4e86\u8fd9\u4e2a\u914d\u7f6e,\u5982\u6709\uff0c\u8bf7\u53bb\u9664");
        }
        if (this.eurekaClient != null && AopUtils.isAopProxy((Object)this.eurekaClient)) {
            throw new IllegalStateException("\u68c0\u6d4b\u5230eurekaClient\u5b9e\u4f8b\u662f\u7ecf\u8fc7\u4ee3\u7406\u7684\uff0c\u8fd9\u5e94\u8be5\u662fspring-cloud\u65b0\u7248\u672c\u53d8\u66f4\u8fc7\u76f8\u5173\u4ee3\u7801\u5bfc\u81f4\u7684\uff0c\u8fd9\u53ef\u80fd\u4f1a\u5bfc\u81f4/refresh\u7684\u65f6\u5019\u672c\u5b9e\u4f8b\u4e0d\u518d\u6ce8\u518c\u5230eureka\u4e0a\uff0c\u5982\u9047\u5230\u6b64\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u4e2d\u95f4\u4ef6\u56e2\u961f\u4fee\u590d\u6b64\u95ee\u9898");
        }
    }
}

