/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisConnectionConfiguration;
import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisProperties;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.JedisClientConfigurationBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnClass(value={GenericObjectPool.class, JedisConnection.class, Jedis.class})
class JedisConnectionConfiguration
extends RedisConnectionConfiguration {
    private final RedisProperties properties;
    private final List<JedisClientConfigurationBuilderCustomizer> builderCustomizers;

    JedisConnectionConfiguration(RedisProperties properties, ObjectProvider<RedisSentinelConfiguration> sentinelConfiguration, ObjectProvider<RedisClusterConfiguration> clusterConfiguration, ObjectProvider<List<JedisClientConfigurationBuilderCustomizer>> builderCustomizers) {
        super(properties, sentinelConfiguration, clusterConfiguration);
        this.properties = properties;
        this.builderCustomizers = (List)builderCustomizers.getIfAvailable(Collections::emptyList);
    }

    @Bean(name={"redisConnectionFactory"})
    @ConditionalOnMissingBean(name={"redisConnectionFactory"})
    public JedisConnectionFactory redisConnectionFactory() throws UnknownHostException {
        return this.createJedisConnectionFactory();
    }

    private JedisConnectionFactory createJedisConnectionFactory() {
        JedisClientConfiguration clientConfiguration = this.getJedisClientConfiguration();
        if (this.getSentinelConfig() != null) {
            return new JedisConnectionFactory(this.getSentinelConfig(), clientConfiguration);
        }
        if (this.getClusterConfiguration() != null) {
            return new JedisConnectionFactory(this.getClusterConfiguration(), clientConfiguration);
        }
        return new JedisConnectionFactory(this.getStandaloneConfig(), clientConfiguration);
    }

    private JedisClientConfiguration getJedisClientConfiguration() {
        JedisClientConfiguration.JedisClientConfigurationBuilder builder = this.applyProperties(JedisClientConfiguration.builder());
        RedisProperties.Pool pool = this.properties.getPool();
        if (pool != null) {
            this.applyPooling(pool, builder);
        }
        this.customize(builder);
        return builder.build();
    }

    private JedisClientConfiguration.JedisClientConfigurationBuilder applyProperties(JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        if (this.properties.isSsl()) {
            builder.useSsl();
        }
        if (this.properties.getTimeout() != null) {
            Duration timeout = this.properties.getTimeout();
            builder.readTimeout(timeout).connectTimeout(timeout);
        }
        return builder;
    }

    private void applyPooling(RedisProperties.Pool pool, JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        builder.usePooling().poolConfig((GenericObjectPoolConfig)this.jedisPoolConfig(pool));
    }

    private JedisPoolConfig jedisPoolConfig(RedisProperties.Pool pool) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(pool.getMaxActive());
        config.setMaxIdle(pool.getMaxIdle());
        config.setMinIdle(pool.getMinIdle());
        if (pool.getMaxWait() != null) {
            config.setMaxWaitMillis(pool.getMaxWait().toMillis());
        }
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(90000L);
        config.setSoftMinEvictableIdleTimeMillis(180000L);
        config.setMinEvictableIdleTimeMillis(-1L);
        config.setNumTestsPerEvictionRun(-1);
        return config;
    }

    private void customize(JedisClientConfiguration.JedisClientConfigurationBuilder builder) {
        for (JedisClientConfigurationBuilderCustomizer customizer : this.builderCustomizers) {
            customizer.customize(builder);
        }
    }
}

