/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class RecordDetailContext {
    private final List<String> stackFramesPrefixWhitelist;
    private final Map<String, Map<String, String>> traceSpanStackFramesMap;

    public RecordDetailContext(List<String> stackFramesPrefixWhitelist) {
        this.stackFramesPrefixWhitelist = stackFramesPrefixWhitelist;
        this.traceSpanStackFramesMap = new ConcurrentHashMap<String, Map<String, String>>();
    }

    public void setSpanStackTrace(FlowReplaySpan span) {
        String[] stackFrames = ExceptionUtils.getStackFrames((Throwable)new Exception());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stackFrames.length; ++i) {
            if (i == 0) continue;
            String frame = stackFrames[i];
            if (i >= 6 && !this.isPrefixWhitelistStackFrame(frame)) continue;
            sb.append(frame).append("\n");
        }
        Map spanStackFramesMap = this.traceSpanStackFramesMap.computeIfAbsent(span.getTraceId(), k -> new ConcurrentHashMap());
        spanStackFramesMap.computeIfAbsent(span.getSpanId(), k -> sb.toString());
    }

    public Map<String, String> getAndRemoveTraceSpanStackFrames(String traceId) {
        Map<String, String> spanStackFramesMap = this.traceSpanStackFramesMap.get(traceId);
        this.traceSpanStackFramesMap.remove(traceId);
        return spanStackFramesMap != null ? spanStackFramesMap : Collections.emptyMap();
    }

    private boolean isPrefixWhitelistStackFrame(String frame) {
        if (!frame.startsWith("\tat ")) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.stackFramesPrefixWhitelist)) {
            return false;
        }
        for (String prefix : this.stackFramesPrefixWhitelist) {
            if (!frame.contains(prefix)) continue;
            return true;
        }
        return false;
    }
}

