/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.CustomizeFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RecordCustomizeFlowReplaySpanPlugin {
    private static final Logger log = LoggerFactory.getLogger(RecordCustomizeFlowReplaySpanPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *.*(..)) && @annotation(cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan)")
    public Object customizeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Object ret;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        FlowReplayCustomizeSpan customizeSpan = signature.getMethod().getAnnotation(FlowReplayCustomizeSpan.class);
        if (customizeSpan == null || !FlowReplayTrace.isTraced()) {
            return joinPoint.proceed();
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return joinPoint.proceed();
        }
        Method method = signature.getMethod();
        Object[] parameterValues = joinPoint.getArgs();
        Object obj = joinPoint.getTarget();
        IgnoreSubInvokesContext.instMark(obj, method.getName(), parameterValues);
        try {
            ret = joinPoint.proceed();
        }
        catch (Throwable t) {
            FlowReplayTrace.remove();
            IgnoreSubInvokesContext.unmark();
            throw t;
        }
        try {
            CustomizeFlowReplaySpan span = CustomizeFlowReplaySpan.createSpan(signature, parameterValues, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
        }
        catch (Throwable t) {
            log.error("Customize_\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }
}

