/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.BufferedHttpResponseWapper;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.HttpClientFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import java.lang.reflect.Method;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordHttpClientMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RecordHttpClientMethodInterceptor.class);

    private boolean canRecord(Method method, Object[] allArguments) {
        if (!"doExecute".equals(method.getName())) {
            return false;
        }
        return FlowReplayTrace.isTraced();
    }

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!this.canRecord(method, allArguments)) {
            return;
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return;
        }
        IgnoreSubInvokesContext.instMark(obj, method.getName(), allArguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (!this.canRecord(method, allArguments)) {
            return ret;
        }
        if (!IgnoreSubInvokesContext.isInstMarked(obj, method.getName(), allArguments)) {
            return ret;
        }
        try {
            HttpEntityEnclosingRequest entityEnclosingRequest;
            HttpEntity httpEntity;
            HttpHost httpHost = (HttpHost)allArguments[0];
            HttpRequest httpRequest = (HttpRequest)allArguments[1];
            if (httpRequest instanceof HttpEntityEnclosingRequest && !(httpEntity = (entityEnclosingRequest = (HttpEntityEnclosingRequest)httpRequest).getEntity()).isRepeatable()) {
                FlowReplayTrace.remove();
                log.debug("{}\u7684entityEnclosingRequest.getEntity\u4e0d\u53ef\u88ab\u591a\u6b21\u8c03\u7528\uff0c\u5f53\u524d\u7528\u4f8b\u53d6\u6d88\u5f55\u5236\u3002", (Object)HttpClientFlowReplaySpan.parseUrl(httpHost, httpRequest));
                Object object = ret;
                return object;
            }
            CloseableHttpResponse response = (CloseableHttpResponse)ret;
            BufferedHttpResponseWapper responseWapper = new BufferedHttpResponseWapper(response);
            ret = responseWapper;
            HttpClientFlowReplaySpan span = HttpClientFlowReplaySpan.createSpan(httpHost, httpRequest, responseWapper);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
        }
        catch (Throwable t) {
            log.error("httpClient\u5f55\u5236\u5f02\u5e38", t);
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (FlowReplayTrace.isTraced()) {
            FlowReplayTrace.remove();
        }
    }
}

