/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RecordDetailContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint.ReplayConfigDto;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReplayContext {
    private static final Logger log = LoggerFactory.getLogger(ReplayContext.class);
    private static final int TRACE_QUEUE_SIZE = 500;
    private static final int RESULT_QUEUE_SIZE = 500;
    private final Long reportId;
    private final String usecaseSetUrl;
    private final Integer replayThreadPoolSize;
    private volatile Long startTime;
    private volatile Long endTime;
    private LinkedBlockingQueue<FlowReplayTrace> traceQueue;
    private volatile boolean tracesLoadFinished;
    private LinkedBlockingQueue<ReplayTraceResult> resultQueue;
    private volatile boolean replayersDone;
    private volatile ReplayResult replayResult;
    private final RecordDetailContext replayDetailContext;

    public ReplayContext(ReplayConfigDto replayConfig) {
        if (replayConfig == null || !replayConfig.isLegal()) {
            throw new FlowReplayException("\u56de\u653e\u914d\u7f6e\u4e3a\u7a7aor\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.reportId = replayConfig.getReportId();
        this.usecaseSetUrl = replayConfig.getUsecaseSetUrl();
        this.traceQueue = new LinkedBlockingQueue(500);
        this.resultQueue = new LinkedBlockingQueue(500);
        this.tracesLoadFinished = false;
        this.replayersDone = false;
        this.startTime = null;
        this.endTime = null;
        this.replayResult = null;
        this.replayThreadPoolSize = replayConfig.getReplayThreadPoolSize();
        this.replayDetailContext = new RecordDetailContext(replayConfig.getStackFramesPrefixWhitelist());
    }

    public RecordDetailContext getReplayDetailContext() {
        return this.replayDetailContext;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
        this.traceQueue.clear();
        this.resultQueue.clear();
    }

    public void putTrace(FlowReplayTrace trace) throws InterruptedException {
        this.traceQueue.put(trace);
    }

    public FlowReplayTrace pollTrace() throws InterruptedException {
        return this.traceQueue.poll(2L, TimeUnit.SECONDS);
    }

    public boolean isTraceQueueEmpty() {
        return this.traceQueue.size() < 1;
    }

    public void tracesLoadFinish() {
        this.tracesLoadFinished = true;
        log.debug("\u5f15\u6d41\u56de\u5f52_\u7528\u4f8b\u96c6\u52a0\u8f7d\u7ed3\u675f_reportId_{}", (Object)this.reportId);
    }

    public boolean isTracesLoadFinished() {
        return this.tracesLoadFinished;
    }

    public void putResult(ReplayTraceResult result) throws InterruptedException {
        this.resultQueue.put(result);
    }

    public ReplayTraceResult pollResult() throws InterruptedException {
        return this.resultQueue.poll(2L, TimeUnit.SECONDS);
    }

    public boolean isResultQueueEmpty() {
        return this.resultQueue.size() < 1;
    }

    public void replayersDone() {
        this.replayersDone = true;
        log.debug("\u5f15\u6d41\u56de\u5f52_\u56de\u653e\u5668\u56de\u653e\u7ed3\u675f_reportId_{}", (Object)this.reportId);
    }

    public boolean isReplayersDone() {
        return this.replayersDone;
    }

    public Long getReportId() {
        return this.reportId;
    }

    public String getUsecaseSetUrl() {
        return this.usecaseSetUrl;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public ReplayResult getReplayResult() {
        return this.replayResult;
    }

    public void setReplayResult(ReplayResult replayResult) {
        this.replayResult = replayResult;
    }

    public Integer getReplayThreadPoolSize() {
        return this.replayThreadPoolSize;
    }
}

