/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.GuavaCacheFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.KryoException;

public class ReplayGuavaCacheMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplayGuavaCacheMethodInterceptor.class);

    private boolean canReplay(Method method, Object[] allArguments) {
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return false;
        }
        if (!FlowReplayConstants.GUAVA_CACHE_AOP_METHOD.contains(method.getName())) {
            return false;
        }
        return !FlowReplayUtils.isGlobalWhitelist(allArguments);
    }

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (!this.canReplay(method, allArguments)) {
            return;
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        GuavaCacheFlowReplaySpan replayDetailSpan = this.createReplayDetailSpan(method, allArguments, argumentsTypes, span);
        if (span == null || SpanType.GUAVA_CACHE != span.getSpanType()) {
            String expert = SpanType.GUAVA_CACHE.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        GuavaCacheFlowReplaySpan guavaSpan = (GuavaCacheFlowReplaySpan)span;
        if (!FlowReplayUtils.isMethodEqual(guavaSpan.getMethodName(), method)) {
            String expert = guavaSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_402, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (!FlowReplayUtils.isArgumentsTypesEqual(guavaSpan.getParameterTypes(), GuavaCacheFlowReplaySpan.customizeArgumentsTypes(method, argumentsTypes))) {
            String expert = FlowReplayUtils.stringArrayToString(guavaSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(argumentsTypes);
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_400, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            if (!FlowReplayUtils.isArgumentsEqual(guavaSpan.getParameterValues(), GuavaCacheFlowReplaySpan.customizeParameterValues(method, allArguments))) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_401);
                throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
            }
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_403, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Object mockRet = guavaSpan.getReturnValue();
            replayDetailSpan.setRet(method, mockRet);
            result.defineReturnValue(mockRet);
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_404, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }

    private GuavaCacheFlowReplaySpan createReplayDetailSpan(Method method, Object[] allArguments, Class<?>[] argumentsTypes, FlowReplaySpan span) {
        GuavaCacheFlowReplaySpan replayDetailSpan = GuavaCacheFlowReplaySpan.createSpan(method, allArguments, argumentsTypes, null);
        replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
        if (span != null) {
            replayDetailSpan.setSpanId(span.getSpanId());
        }
        FlowReplayTrace.addSubSpan(replayDetailSpan);
        return replayDetailSpan;
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

