/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RedisFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.com.esotericsoftware.kryo.KryoException;

public class ReplayJedisMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplayJedisMethodInterceptor.class);
    private static final List<String> REPLAY_FAST_MOCK_METHODS = Arrays.asList("expire", "expireAt", "pexpire", "pexpireAt");
    private static final List<String> SETEX_METHODS = Arrays.asList("setex", "psetex");

    private boolean canReplay(Method method, Object[] allArguments) {
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return false;
        }
        if (FlowReplayConstants.REDIS_AOP_EXCLUDE_METHOD.contains(method.getName())) {
            return false;
        }
        return !FlowReplayUtils.isGlobalWhitelist(allArguments);
    }

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        if (!this.canReplay(method, allArguments)) {
            return;
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        RedisFlowReplaySpan replayDetailSpan = this.createReplayDetailSpan(method, allArguments, argumentsTypes, span);
        if (span == null || SpanType.REDIS != span.getSpanType()) {
            String expert = SpanType.REDIS.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        RedisFlowReplaySpan redisSpan = (RedisFlowReplaySpan)span;
        if (!FlowReplayUtils.isMethodEqual(redisSpan.getMethodName(), method)) {
            String expert = redisSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_102, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        if (REPLAY_FAST_MOCK_METHODS.contains(method.getName())) {
            try {
                Object mockRet = redisSpan.getReturnValue();
                replayDetailSpan.setReturnValue(mockRet);
                result.defineReturnValue(mockRet);
                return;
            }
            catch (KryoException e) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_104, e);
                throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
            }
        }
        if (!FlowReplayUtils.isArgumentsTypesEqual(redisSpan.getParameterTypes(), argumentsTypes)) {
            String expert = FlowReplayUtils.stringArrayToString(redisSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(argumentsTypes);
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_100, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Object[] recordParameterValues = redisSpan.getParameterValues();
            Object[] replayParameterValues = allArguments;
            if (SETEX_METHODS.contains(method.getName())) {
                recordParameterValues = new Object[]{recordParameterValues[0], recordParameterValues[2]};
                replayParameterValues = new Object[]{replayParameterValues[0], replayParameterValues[2]};
            }
            if (!FlowReplayUtils.isArgumentsEqual(recordParameterValues, replayParameterValues)) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_101);
                throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
            }
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_103, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Object mockRet = redisSpan.getReturnValue();
            replayDetailSpan.setReturnValue(mockRet);
            result.defineReturnValue(mockRet);
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_104, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }

    private RedisFlowReplaySpan createReplayDetailSpan(Method method, Object[] allArguments, Class<?>[] argumentsTypes, FlowReplaySpan span) {
        RedisFlowReplaySpan replayDetailSpan = RedisFlowReplaySpan.createSpan(method, allArguments, argumentsTypes, null);
        replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
        if (span != null) {
            replayDetailSpan.setSpanId(span.getSpanId());
        }
        FlowReplayTrace.addSubSpan(replayDetailSpan);
        return replayDetailSpan;
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

