/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.FlowReplayTraceMapHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.ReplayTraceContextMapHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.Replayer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpringMvcFlowReplaySpan;
import java.io.Closeable;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;

public class SpringMvcReplayer
implements Replayer {
    private static final Logger log = LoggerFactory.getLogger(SpringMvcReplayer.class);
    public static final String TRACE_ID = "Flow-Replay-Trace-Id";
    private volatile CloseableHttpClient httpClient;
    @Value(value="${server.port}")
    private int httpServerPort;

    @EventListener(value={ReplayStartEvent.class})
    public void replayStartEventListener(ReplayStartEvent event) {
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(10).build()).setMaxConnPerRoute(100).setMaxConnTotal(5000).disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().useSystemProperties().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        }).build();
    }

    @EventListener(value={ReplayEndEvent.class})
    public void replayEndEventListener(ReplayEndEvent event) {
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }

    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {
        SpringMvcFlowReplaySpan span = (SpringMvcFlowReplaySpan)trace.getMainSpan();
        String traceId = trace.getTraceId();
        FlowReplayTraceMapHolder.put(trace);
        ReplayTraceContextMapHolder.preset(traceId);
        HttpUriRequest request = this.buildHttpUriRequest(span);
        ReplayTraceContext context = null;
        byte[] replayResultValue = null;
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                replayResultValue = EntityUtils.toByteArray((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            log.error("SpringMvcReplayer_httpClient_error", (Throwable)e);
            throw new FlowReplayException(e);
        }
        finally {
            context = ReplayTraceContextMapHolder.getAndRemove(traceId);
        }
        if (context == null) {
            throw new FlowReplayException("\u5355\u4e2a\u7528\u4f8b\u56de\u653e\u4e0a\u4e0b\u6587\u4e22\u5931_traceId=" + traceId);
        }
        if (context.isErrorMarked()) {
            return ReplayTraceResult.failResult(trace, context.getReplayDetailTrace(), context.getErrorMsgType(), context.getErrorMsgDetail());
        }
        return ReplayTraceResult.successResult(trace, context.getReplayDetailTrace(), replayResultValue);
    }

    private HttpUriRequest buildHttpUriRequest(SpringMvcFlowReplaySpan span) {
        Map<String, String[]> parameters;
        RequestBuilder requestBuilder = RequestBuilder.create((String)span.getMethod().name()).setUri("http://localhost:" + this.httpServerPort + span.getUri());
        Map<String, String> headers = span.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                requestBuilder.setHeader(entry.getKey(), entry.getValue());
            }
            requestBuilder.setHeader(TRACE_ID, span.getTraceId());
        }
        if ((parameters = span.getParameters()) != null) {
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                for (String value : entry.getValue()) {
                    requestBuilder.addParameter(entry.getKey(), value);
                }
            }
        }
        requestBuilder.removeHeaders("Content-Length");
        byte[] byArray = span.getRequestBody();
        if (byArray != null) {
            requestBuilder.setEntity((HttpEntity)new ByteArrayEntity(byArray, ContentType.APPLICATION_JSON));
        }
        return requestBuilder.build();
    }
}

