/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpMethod;

public class SpringMvcFlowReplaySpan
extends FlowReplaySpan {
    private static final long serialVersionUID = -3775118543698169978L;
    private HttpMethod method;
    private String uri;
    private String springBestMatchingUri;
    private Map<String, String> headers;
    private Map<String, String[]> parameters;
    private byte[] requestBody;
    private byte[] responseBody;

    @Override
    public SpanType getSpanType() {
        return SpanType.SPRING_MVC;
    }

    public static SpringMvcFlowReplaySpan createSpan(HttpServletRequest request) throws IOException {
        SpringMvcFlowReplaySpan span = new SpringMvcFlowReplaySpan();
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headNames = request.getHeaderNames();
        while (headNames.hasMoreElements()) {
            String headName = (String)headNames.nextElement();
            Enumeration h = request.getHeaders(headName);
            ArrayList hs = new ArrayList();
            while (h.hasMoreElements()) {
                hs.add(h.nextElement());
            }
            headers.put(headName, Joiner.on((String)";").join(hs));
        }
        headers.put("X-Forwarded-For", (String)request.getAttribute("originalXForwardedFor"));
        span.setSpanId(UUIDUtils.createUUID());
        span.method = HttpMethod.resolve((String)request.getMethod());
        span.uri = request.getRequestURI();
        span.headers = headers;
        span.parameters = request.getParameterMap();
        span.springBestMatchingUri = null;
        span.requestBody = IOUtils.toByteArray((InputStream)request.getInputStream());
        return span;
    }

    public void setResponseBody(byte[] responseBody) throws IOException {
        this.responseBody = responseBody;
    }

    public void setSpringBestMatchingUri(String springBestMatchingUri) {
        this.springBestMatchingUri = springBestMatchingUri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public String getSpringBestMatchingUri() {
        return this.springBestMatchingUri;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public byte[] getRequestBody() {
        return this.requestBody;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }
}

