/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Lists;
import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CacheMetricsCollector
extends Collector {
    protected final ConcurrentMap<String, Object> children = new ConcurrentHashMap<String, Object>();
    protected final ConcurrentMap<String, List<String>> labelsMap = new ConcurrentHashMap<String, List<String>>();

    public void addCache(String cacheName, Object cache, String ip, String service, String namespace) {
        this.children.put(cacheName, cache);
        this.labelsMap.put(cacheName, Arrays.asList(ip, service, namespace));
    }

    public void removeCache(String cacheName) {
        this.children.remove(cacheName);
    }

    public void clear() {
        this.children.clear();
    }

    public long getSize() {
        return this.children.size();
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        ArrayList labelNames = Lists.newArrayList((Object[])new String[]{"cache", "ip", "service", "namespace"});
        GaugeMetricFamily cacheHitRateTotal = new GaugeMetricFamily("guava_cache_hit_rate", "\u7f13\u5b58\u547d\u4e2d\u7387", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheHitRateTotal);
        GaugeMetricFamily cacheFailRateTotal = new GaugeMetricFamily("guava_cache_fail_rate", "\u52a0\u8f7d\u9519\u8bef\u7387", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheFailRateTotal);
        CounterMetricFamily cacheRequestsTotal = new CounterMetricFamily("guava_cache_requests_total", "\u7f13\u5b58\u8bf7\u6c42\u6570\uff1a\u547d\u4e2d + \u672a\u547d\u4e2d ", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheRequestsTotal);
        CounterMetricFamily cacheEvictionTotal = new CounterMetricFamily("guava_cache_eviction_total", "\u7f13\u5b58\u56de\u6536\u603b\u6570\uff0c\u4e0d\u5305\u62ec\u663e\u793a\u6e05\u9664\u7684", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheEvictionTotal);
        GaugeMetricFamily cacheSize = new GaugeMetricFamily("guava_cache_size", "\u7f13\u5b58\u603b\u6570", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheSize);
        GaugeMetricFamily cacheLoadSummary = new GaugeMetricFamily("guava_cache_load_duration_seconds", "\u7f13\u5b58\u5e73\u5747\u52a0\u8f7d\u65f6\u95f4\uff0c\u5305\u62ec\u52a0\u8f7d\u5931\u8d25\u548c\u6210\u529f", (List)labelNames);
        mfs.add((Collector.MetricFamilySamples)cacheLoadSummary);
        for (Map.Entry c : this.children.entrySet()) {
            CacheStats stats;
            com.google.common.cache.Cache cache;
            ArrayList labelValues = Lists.newArrayList((Object[])new String[]{(String)c.getKey()});
            labelValues.addAll((Collection)this.labelsMap.get(c.getKey()));
            if (c.getValue() instanceof com.google.common.cache.Cache) {
                cache = (com.google.common.cache.Cache)c.getValue();
                stats = cache.stats();
                cacheHitRateTotal.addMetric((List)labelValues, stats.hitRate());
                cacheFailRateTotal.addMetric((List)labelValues, stats.loadExceptionRate());
                cacheRequestsTotal.addMetric((List)labelValues, (double)stats.requestCount());
                cacheLoadSummary.addMetric((List)labelValues, stats.averageLoadPenalty());
                cacheEvictionTotal.addMetric((List)labelValues, (double)stats.evictionCount());
                cacheSize.addMetric((List)labelValues, (double)cache.size());
            }
            if (!(c.getValue() instanceof Cache)) continue;
            cache = (Cache)c.getValue();
            stats = cache.stats();
            cacheHitRateTotal.addMetric((List)labelValues, stats.hitRate());
            cacheFailRateTotal.addMetric((List)labelValues, stats.loadFailureRate());
            cacheRequestsTotal.addMetric((List)labelValues, (double)stats.requestCount());
            cacheLoadSummary.addMetric((List)labelValues, stats.averageLoadPenalty());
            cacheEvictionTotal.addMetric((List)labelValues, (double)stats.evictionCount());
            cacheSize.addMetric((List)labelValues, (double)cache.estimatedSize());
        }
        return mfs;
    }
}

