/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.policy.AbortPolicyWithReport;
import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ScheduledThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.ProfileCallable;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.ProfileRunnable;
import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncTaskExecutor;

public class ThreadPoolExecutorWrapper
implements AsyncTaskExecutor,
ExecutorService,
SmartLifecycle {
    private final ThreadPoolExecutor threadPoolExecutor;
    private final ThreadPoolProperties poolProperties;
    private final String threadPoolName;
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolExecutorWrapper.class);

    public ThreadPoolExecutorWrapper(String threadPoolName, ThreadPoolProperties poolProperties) {
        this.poolProperties = poolProperties;
        this.threadPoolName = threadPoolName;
        Objects.requireNonNull(threadPoolName);
        Objects.requireNonNull(poolProperties);
        if (poolProperties instanceof ScheduledThreadPoolProperties) {
            this.threadPoolExecutor = new ScheduledThreadPoolExecutor(poolProperties.getCoreSize(), (ThreadFactory)new NamedThreadFactory(threadPoolName), new AbortPolicyWithReport());
        } else {
            int maxSize = Math.max(poolProperties.getMaxSize(), poolProperties.getCoreSize());
            int queueSize = poolProperties.getQueueSize();
            AbstractQueue queue = queueSize == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize);
            this.threadPoolExecutor = new ThreadPoolExecutor(poolProperties.getCoreSize(), maxSize, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue), (ThreadFactory)new NamedThreadFactory(threadPoolName), new AbortPolicyWithReport());
        }
    }

    @Override
    @PreDestroy
    public void shutdown() {
        this.threadPoolExecutor.shutdown();
    }

    public void shutdownGracefully() {
        this.threadPoolExecutor.shutdown();
        Long shutdownTimeout = this.poolProperties.getShutdownTimeout();
        try {
            this.threadPoolExecutor.awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.error("", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!this.threadPoolExecutor.isShutdown()) {
            logger.warn("\u7ebf\u7a0b\u6c60\u8d85\u8fc7{}ms\u4ecd\u672a\u5173\u95ed\uff0c\u5f3a\u5236\u5173\u95ed\u3002", (Object)this.poolProperties.getShutdownTimeout());
            this.threadPoolExecutor.shutdownNow();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.threadPoolExecutor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.threadPoolExecutor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.threadPoolExecutor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.threadPoolExecutor.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.threadPoolExecutor.execute((Runnable)TtlRunnable.get((Runnable)new ProfileRunnable(command, this.getQueue(), this.threadPoolName)));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.threadPoolExecutor.submit(TtlCallable.get((Callable)new ProfileCallable(task, this.getQueue(), this.threadPoolName)));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.threadPoolExecutor.submit((Runnable)TtlRunnable.get((Runnable)new ProfileRunnable(task, this.getQueue(), this.threadPoolName)), result);
    }

    public void execute(Runnable task, long startTimeout) {
        this.threadPoolExecutor.execute((Runnable)TtlRunnable.get((Runnable)new ProfileRunnable(task, this.getQueue(), this.threadPoolName)));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.threadPoolExecutor.submit((Runnable)TtlRunnable.get((Runnable)new ProfileRunnable(task, this.getQueue(), this.threadPoolName)));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.threadPoolExecutor.invokeAll(TtlCallable.gets(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.threadPoolExecutor.invokeAll(TtlCallable.gets(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.threadPoolExecutor.invokeAny(TtlCallable.gets(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.threadPoolExecutor.invokeAny(TtlCallable.gets(tasks), timeout, unit);
    }

    public boolean isTerminating() {
        return this.threadPoolExecutor.isTerminating();
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.threadPoolExecutor.getQueue();
    }

    public int getPoolSize() {
        return this.threadPoolExecutor.getPoolSize();
    }

    public int getCorePoolSize() {
        return this.threadPoolExecutor.getCorePoolSize();
    }

    public int getActiveCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    public int getLargestPoolSize() {
        return this.threadPoolExecutor.getLargestPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.threadPoolExecutor.getMaximumPoolSize();
    }

    public long getTaskCount() {
        return this.threadPoolExecutor.getTaskCount();
    }

    public long getCompletedTaskCount() {
        return this.threadPoolExecutor.getCompletedTaskCount();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(final Runnable callback) {
        new Thread(){

            @Override
            public void run() {
                try {
                    ThreadPoolExecutorWrapper.this.shutdownGracefully();
                }
                finally {
                    callback.run();
                }
            }
        }.start();
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return !this.threadPoolExecutor.isTerminating() && !this.threadPoolExecutor.isTerminated();
    }

    public int getPhase() {
        return -2;
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    protected ThreadPoolExecutor getInnerThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }
}

