package cn.com.duibaboot.ext.autoconfigure.batch;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;


/**
 * 合并请求，用来降低后端RCP接口的调用量
 * 用法流程
 * 1.注解在方法上
 * 2.调用此方法时，系统会拦截此方法,将原方法参数合并成list参数,调用指定的批量接口
 * 3.批量接口的返回结果拆分后，返回原方法返回值
 */
@Target({METHOD})
@Retention(RUNTIME)
public @interface MergeRequest {

    /**
     * 批量调用的方法名称
     *
     * @return
     */
    String method();

    /**
     * 等待返回结果的超时时间（毫秒）
     *
     * @return
     */
    int timeout() default 200;

    /**
     * 是否只调用不等待返回结果（适用于 void 方法）
     *
     * @return
     */
    boolean oneway() default false;

}
