package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.cloud.netflix.ribbon.RibbonLoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;

/**
 * 用于替换 默认的 RibbonLoadBalancerClient，提供自定义的choose方法的实现，支持传递loadBalanderKey,从而支持传递压测、服务分组等相关信息。
 */
public class RibbonLoadBalancerClientBeanPostProcessor implements SpecifiedBeanPostProcessor<RibbonLoadBalancerClient> {
    @Override
    public Class<RibbonLoadBalancerClient> getBeanType() {
        return RibbonLoadBalancerClient.class;
    }

    @Override
    public Object postProcessBeforeInitialization(RibbonLoadBalancerClient bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(RibbonLoadBalancerClient bean, String beanName) throws BeansException {
        Field clientFactoryField = ReflectionUtils.findField(RibbonLoadBalancerClient.class, "clientFactory");
        clientFactoryField.setAccessible(true);
        SpringClientFactory clientFactory = (SpringClientFactory)ReflectionUtils.getField(clientFactoryField, bean);

        return new CustomRibbonLoadBalancerClient(clientFactory);
    }

    @Override
    public int getOrder() {
        return 0;
    }
}
