package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.catmonitor.CatInstance;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatUtils {

    private static final Logger logger = LoggerFactory.getLogger(CatUtils.class);

    private CatUtils(){}

    private static final boolean IS_CAT_CLASS_EXISTS;

    static{
        boolean isCatClassExists = true;
        try {
            Class.forName("cn.com.duiba.catmonitor.CatInstance");
        } catch (ClassNotFoundException e) {
            isCatClassExists = false;
        }
        IS_CAT_CLASS_EXISTS = isCatClassExists;
    }

    public static void completeTransaction(Transaction transaction){
        if(logger.isDebugEnabled()) {
            //下面这些代码在transaction.complete内部会调用，打印日志时需要提前调用，以打印出messageId，不影响cat的实际输出
            MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
            String messageId = tree.getMessageId();

            if (messageId == null) {
                messageId = Cat.createMessageId();
                tree.setMessageId(messageId);
            }

            printTransactionLog(transaction, tree);
        }

        transaction.complete();
    }

    private static void printTransactionLog(Transaction t, MessageTree tree){
        if(logger.isDebugEnabled()) {
            logger.debug("mid:{},Cat_type:{},name:{},pid:{},rid:{},thread:{},created:{}", tree.getMessageId(), t.getType(), t.getName(), tree.getParentMessageId(), tree.getRootMessageId(),
                    tree.getThreadName(), t.getTimestamp());
        }
    }

    public static boolean isCatEnabled(){
        return isCatClassExists() && CatInstance.isEnable();
    }

    public static boolean isCatClassExists(){
        return IS_CAT_CLASS_EXISTS;
    }


    /**
     * 对callback内部执行的代码加上cat监控
     *
     * @param callback 要监控耗时的代码段
     * @param type
     * @param name
     * @param <T>
     * @return
     */
    public static <T> T executeInCatTransaction(Callback<T> callback, String type, String name) throws Throwable{
        if(!CatUtils.isCatEnabled()){
            return callback.invoke();
        }

        Transaction transaction = Cat.newTransaction(type, name);
        try {
            T result = callback.invoke();
            transaction.setStatus(Message.SUCCESS);
            return result;
        } catch (Throwable e) {
            Cat.logError(e);
            transaction.setStatus(e);
            throw e;
        }finally{
            transaction.complete();
        }
    }

    /**
     * 回调接口
     * @param <R>
     */
    public interface Callback<R>{
        R invoke() throws Throwable;
    }

}
