package cn.com.duibaboot.ext.autoconfigure.data.elasticsearch;

import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.springframework.data.elasticsearch.core.GetResultMapper;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.query.GetQuery;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年05月02日 10:49
 * @descript:
 * @version: 1.0
 */
public class CustomElasticsearchTemplate extends org.springframework.data.elasticsearch.core.ElasticsearchTemplate {

    private Client client;
    private String searchTimeout;

    public CustomElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter, String searchTimeout) {
        super(client,elasticsearchConverter);
        this.client = client;
        this.searchTimeout = searchTimeout;
    }

    @Override
    public <T> T queryForObject(GetQuery query, Class<T> clazz, GetResultMapper mapper) {

        if(searchTimeout == null){
            return super.queryForObject(query,clazz,mapper);
        }

        ElasticsearchPersistentEntity<T> persistentEntity = getPersistentEntityFor(clazz);
        GetResponse response = client.prepareGet(persistentEntity.getIndexName(), persistentEntity.getIndexType(), query.getId()).execute()
                .actionGet(searchTimeout);

        return mapper.mapResult(response, clazz);
    }
}

