package cn.com.duibaboot.ext.autoconfigure.datasource;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import com.alibaba.fastjson.JSON;
import javax.annotation.Resource;

/**
 * 支持在prism中查看数据库连接池配置
 * Created by guoyanfei .
 * 2019-06-25 .
 */
@Endpoint(id="duibaDataSource")
public class DuibaDataSourceEndpoint {

    @Resource
    private DuibaDataSourceMonitor _duibaDataSourceMonitor;

    @ReadOperation
    public String invoke() {
        return JSON.toJSONString(_duibaDataSourceMonitor.getDataSourceConfig());
    }
}
