package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.collections.CollectionUtils;

import java.util.*;

/**
 * Created by guoyanfei .
 * 2019/11/7 .
 */
public class ParamComparator {

    private static final String EXPR_ROOT_OBJ = "_obj";
    private static final String EXPR_OBJ = "";

    private static final String EXPR_ROOT_ARRAY = "_obj[]";
    private static final String EXPR_ARRAY = "[]";
    private static final String EXPR_ARRAY_LENGTH = "_length";

    private static final String EXPR_ROOT_VALUE = "_value";
    private static final String EXPR_VALUE = "";

    private static final String EXPR_POINT = ".";

    /**
     * 对比 parameterValue
     * @param recordVal
     * @param replayVal
     * @return
     */
    public static CompareResult compareObject(Object recordVal, Object replayVal) {
        Set<DiffItem> diffItems = new HashSet<>();
        innerCompareObject(0, recordVal, replayVal, diffItems, null);
        return new CompareResult(diffItems);
    }

    /**
     * 对比 parameterValues
     * 调用该方法，默认 recordArray 和 replayArray
     * 长度相同
     * 每个元素对应的类型相同
     * @param recordArray
     * @param replayArray
     * @return
     */
    public static CompareResult compareArray(Object[] recordArray, Object[] replayArray) {
        Set<DiffItem> diffItems = new HashSet<>();
        if (recordArray != null && replayArray != null) {
            if (recordArray.length != replayArray.length) {
                DiffContext diffContext = DiffContext.buildArray(null, true);
                diffItems.add(new DiffItem(0, diffContext));
            } else {
                for (int i = 0; i < recordArray.length; i++) {
                    innerCompareObject(i, recordArray[i], replayArray[i], diffItems, null);
                }
            }
        } else if (recordArray != null || replayArray != null) {
            DiffContext diffContext = DiffContext.buildArray(null, false);
            diffItems.add(new DiffItem(0, diffContext));
        }
        return new CompareResult(diffItems);
    }

    private static void innerCompareObject(int paramIdx, Object recordVal, Object replayVal, Set<DiffItem> diffItems, DiffContext parentContext) {  // NOSONAR
        if (recordVal == null && replayVal == null) {
            return;
        }
        if (recordVal == null || replayVal == null) {
            diffItems.add(new DiffItem(paramIdx, DiffContext.buildValue(parentContext)));
            return;
        }
        if (replayVal instanceof String && ((String) replayVal).contains(FlowReplayConstants.DEFAULT_UUID)) {
            return;
        }
        if (recordVal instanceof byte[] && replayVal instanceof byte[]) {
            if (((byte[]) replayVal).length == 32 && FlowReplayConstants.DEFAULT_UUID.equals(new String((byte[]) replayVal))) {
                return;
            }
            if (!Objects.deepEquals(recordVal, replayVal)) {
                diffItems.add(new DiffItem(paramIdx, DiffContext.buildValue(parentContext)));
            }
            return;
        }
        if (recordVal instanceof byte[][] && replayVal instanceof byte[][]) {
            byte[][] recordValArray = (byte[][]) recordVal;
            byte[][] replayValArray = (byte[][]) replayVal;
            if (recordValArray.length != replayValArray.length) {
                diffItems.add(new DiffItem(paramIdx, DiffContext.buildArray(parentContext, true)));
                return;
            }
            for (int i = 0; i < replayValArray.length; i++) {
                byte[] v = replayValArray[i];
                if (v.length == 32 && FlowReplayConstants.DEFAULT_UUID.equals(new String(v))) {
                    continue;
                }
                if (!Objects.deepEquals(recordValArray[i], v)) {
                    diffItems.add(new DiffItem(paramIdx, DiffContext.buildArray(parentContext, false)));
                    return;
                }
            }
            return;
        }
        String recordJson = JSON.toJSONString(recordVal);
        String replayJson = JSON.toJSONString(replayVal);
        Object recordObj = JSON.parse(recordJson);
        Object replayObj = JSON.parse(replayJson);

        if (recordObj instanceof JSONArray && replayObj instanceof JSONArray) {
            innerCompareJSONArray(paramIdx, (JSONArray) recordObj, (JSONArray) replayObj, diffItems, parentContext);
            return;
        }
        if (recordObj instanceof JSONObject && replayObj instanceof JSONObject) {
            innerCompareJSONObject(paramIdx, (JSONObject) recordObj, (JSONObject) replayObj, diffItems, parentContext);
            return;
        }
        if (!recordObj.equals(replayObj)) {
            diffItems.add(new DiffItem(paramIdx, DiffContext.buildValue(parentContext)));
        }
    }

    private static void innerCompareJSONArray(int paramIdx, JSONArray recordArray, JSONArray replayArray, Set<DiffItem> diffItems, DiffContext parentContext) {
        if (recordArray.size() != replayArray.size()) {
            diffItems.add(new DiffItem(paramIdx, DiffContext.buildArray(parentContext, true)));
            return;
        }

        // 遍历录制返回值数组，每一项和回归返回值数组对应的项进行比对
        Iterator<Object> iterator = recordArray.iterator();
        for (int i = 0; iterator.hasNext(); i++) {
            Object recordValue = iterator.next();
            Object replayValue = replayArray.get(i);

            if (FlowReplayConstants.DEFAULT_UUID.equals(replayValue)) {
                continue;
            }

            String recordValueStr = JSON.toJSONString(recordValue);
            if (FlowReplayUtils.isJSONValid(recordValueStr)) { // 如果是jsonObj或者jsonArray，那么再判断内部的东西
                String replayValueStr = (replayValue != null ? JSON.toJSONString(replayValue) : null);
                innerCompareObject(paramIdx, JSON.parse(recordValueStr), JSON.parse(replayValueStr), diffItems, DiffContext.buildArray(parentContext, false));
            } else {    // 如果不是jsonObj或者jsonArray，那么直接进行值对比，如果值不一样，添加对比不一致的结果
                if (!Objects.equals(recordValue, replayValue)) {
                    diffItems.add(new DiffItem(paramIdx, DiffContext.buildArray(parentContext, false)));
                }
            }
        }
    }

    private static void innerCompareJSONObject(int paramIdx, JSONObject recordObj, JSONObject replayObj, Set<DiffItem> diffItems, DiffContext parentContext) {
        for (Map.Entry<String, Object> entry : recordObj.entrySet()) {
            if (FlowReplayConstants.COLUMN_NAME_WHITELIST.contains(entry.getKey())) {
                continue;
            }

            Object recordValue = entry.getValue();
            Object replayValue = replayObj.get(entry.getKey());

            if (FlowReplayConstants.DEFAULT_UUID.equals(replayValue)) {
                continue;
            }

            String recordValueStr = (recordValue != null ? JSON.toJSONString(recordValue) : null);
            String replayValueStr = (replayValue != null ? JSON.toJSONString(replayValue) : null);
            if (FlowReplayUtils.isJSONValid(recordValueStr)) {  // 当前遍历到的value，是个jsonObj或者jsonArray，那么需要递归判断里面的内容
                innerCompareObject(paramIdx, JSON.parse(recordValueStr), JSON.parse(replayValueStr), diffItems, DiffContext.buildObject(parentContext, entry.getKey()));
            } else {    // 当前遍历到的value，不是jsonObj或者jsonArray，那么直接进行值的比对，如果值不一样，添加对比不一致的结果
                if (!Objects.equals(recordValue, replayValue)) {
                    diffItems.add(new DiffItem(paramIdx, DiffContext.buildObject(parentContext, entry.getKey())));
                }
            }
        }
    }

    @Data
    @NoArgsConstructor
    public static class CompareResult {

        private boolean equal;

        private Set<DiffItem> diffItems;

        public CompareResult(Set<DiffItem> diffItems) {
            this.equal = CollectionUtils.isEmpty(diffItems);
            this.diffItems = diffItems;
        }

        @Override
        public String toString() {
            return "{" + "equal=" + equal + ", diffItems=" + diffItems + '}';
        }
    }

    @Data
    public static class DiffItem {

        private int paramIdx;

        private String columnPath;

        public DiffItem(int paramIdx, DiffContext diffContext) {
            this.paramIdx = paramIdx;
            this.columnPath = diffContext.getColumnPath();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof DiffItem)) return false;
            DiffItem diffItem = (DiffItem) o;
            return paramIdx == diffItem.paramIdx && Objects.equals(columnPath, diffItem.columnPath);
        }

        @Override
        public int hashCode() {
            return Objects.hash(paramIdx, columnPath);
        }
    }

    @Data
    @NoArgsConstructor
    public static class DiffContext {

        private String columnPath;

        public static DiffContext buildValue(DiffContext parentContext) {
            String currentPath = (parentContext == null) ? EXPR_ROOT_VALUE : EXPR_VALUE;
            DiffContext context = new DiffContext();
            context.columnPath = (parentContext != null ? parentContext.getColumnPath() : "") + currentPath;
            return context;
        }

        public static DiffContext buildObject(DiffContext parentContext, String currentKey) {
            String currentPath = ((parentContext == null) ? EXPR_ROOT_OBJ : EXPR_OBJ) + EXPR_POINT + currentKey;
            DiffContext context = new DiffContext();
            context.columnPath = (parentContext != null ? parentContext.getColumnPath() : "") + currentPath;
            return context;
        }

        public static DiffContext buildArray(DiffContext parentContext, boolean isLengthDiff) {
            String currentPath = ((parentContext == null) ? EXPR_ROOT_ARRAY : EXPR_ARRAY) + (isLengthDiff ? EXPR_POINT + EXPR_ARRAY_LENGTH : "");
            DiffContext context = new DiffContext();
            context.columnPath = (parentContext != null ? parentContext.getColumnPath() : "") + currentPath;
            return context;
        }

    }

}
