package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayFileComponent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * 回归结果构建器
 * Created by guoyanfei .
 * 2019-02-25 .
 */
@Slf4j
public class ReplayResultBuilder {

    @Resource
    private FlowReplayFileComponent flowReplayFileComponent;

    @Value("${logging.path}")
    private String duibaLoggerPath;

    /**
     * 监听"回归结束"事件
     * @param event
     * @throws IOException
     */
    @EventListener(ReplayEndEvent.class)
    public void replayEndEventListener(ReplayEndEvent event) {
        new Thread(new Runnable() {

            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }

                String ossPath = null;
                String replayDetailOssPath = null;
                try {
                    ossPath = flowReplayFileComponent.upload(FlowReplayConstants.LOCAL_RESULT_FILEPATH);
                    replayDetailOssPath = flowReplayFileComponent.upload(FlowReplayConstants.LOCAL_REPLAY_DETAIL_FILEPATH);
                } catch (IOException e) {
                    log.error("回归报告/回归详情_文件操作异常_reportId_{}", context.getReportId(), e);
                }

                try {
                    Thread.sleep(6000); // 日志打印可能有5秒左右延迟，等日志打完之后再开始上传
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }

                String applicationLogUrl = null;
                try {
                    applicationLogUrl = flowReplayFileComponent.upload(FlowReplayConstants.LOCAL_REPLAY_LOG_PATH);
                    flowReplayFileComponent.clearFile(FlowReplayConstants.LOCAL_REPLAY_LOG_PATH + "/replay.log");
                } catch (IOException e) {
                    log.error("上传应用日志_文件操作异常_reportId_{}", context.getReportId(), e);
                }

                // 清空引流回归文件目录，但是不清日志目录
                FlowReplayFileComponent.removeDir();

                ReplayResult result = new ReplayResult();
                result.setReportId(context.getReportId());
                result.setOssPath(ossPath);
                result.setReplayDetailPath(replayDetailOssPath);
                result.setApplicationLogUrl(applicationLogUrl);
                result.setStartTime(context.getStartTime());
                result.setEndTime(context.getEndTime());
                context.setReplayResult(result);
            }
        }, "DBThread-Replay-上传回归报告").start();
    }

}
