package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Objects;

/**
 * 中间步骤对比不一致字段
 * Created by guoyanfei .
 * 2019/11/7 .
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class StepDiffColumn implements Serializable {

    private static final long serialVersionUID = 1996569185704951899L;

    private String traceId;

    private int spanIdx;

    private int paramIdx;

    private String columnPath;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof StepDiffColumn)) return false;
        StepDiffColumn that = (StepDiffColumn) o;
        return spanIdx == that.spanIdx && paramIdx == that.paramIdx && Objects.equals(traceId, that.traceId) && Objects.equals(columnPath, that.columnPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(traceId, spanIdx, paramIdx, columnPath);
    }
}
