package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import lombok.extern.slf4j.Slf4j;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;

/**
 * 流量回归终止端点
 * Created by guoyanfei .
 * 2019-02-19 .
 */
@Slf4j
@Endpoint(id="flow-replay-stop")
public class ReplayStopMvcEndpoint {

    @WriteOperation
    public String invoke() {
        JsonResult<String> result;
        try {
            if (!FlowReplayUtils.isReplayEnv()) {
                throw new FlowReplayException("当前服务非回归专用服务，无法进行回归相关操作");
            }
            ReplayContextHolder.forceEnd();
            result = JsonResult.successResult("ok");
        } catch (FlowReplayException e) {
            result = JsonResult.failedResult(e.getMessage());
        } catch (Exception e) {
            log.error("回归stop异常", e);
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
