package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;

import java.lang.reflect.Method;

/**
 * feignClient 类型的 Span
 * Created by guoyanfei .
 * 2019-01-24 .
 */
public class FeignClientFlowReplaySpan extends StandardSpan {

    private static final long serialVersionUID = 6228393678957825891L;

    /**
     * 接口名称
     */
    private String apiName;

    /**
     * 类名
     */
    private String typeName;

    /**
     * 接口所在类，全路径，例如：cn.com.duiba.message.service.remoteservice.RemoteSmsService
     */
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.FEIGN_CLIENT;
    }

    public static FeignClientFlowReplaySpan createSpan(Method method, Object[] args, Object ret) {
        Class[] parameterTypeClasses = method.getParameterTypes();
        String[] parameterTypes = null;
        if (parameterTypeClasses.length > 0) {
            parameterTypes = new String[parameterTypeClasses.length];
            for (int i = 0; i < parameterTypeClasses.length; i++) {
                parameterTypes[i] = parameterTypeClasses[i].getName();
            }
        }
        Class returnTypeClass = method.getReturnType();
        FeignClientFlowReplaySpan span = new FeignClientFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMethodName(method.getName());
        span.setParameterTypes(parameterTypes);
        span.setParameterValues(args);
        span.setReturnType(returnTypeClass != null ? returnTypeClass.getName() : null);
        span.setReturnValue(ret);
        span.apiName = FlowReplayUtils.parseApiNameByMethod(method);
        span.typeName = method.getDeclaringClass().getSimpleName();
        span.typeFullPath = method.getDeclaringClass().getName();
        return span;
    }

    public String getApiName() {
        return apiName;
    }

    public String getTypeName() {
        return typeName;
    }

    public String getTypeFullPath() {
        return typeFullPath;
    }

}
