package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import org.apache.commons.lang3.StringUtils;

import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-22 19:41
 * @descript: 缓存状态拦截: /monitor/cache/all 获取所有缓存
 * @version: 1.0
 */
@ControllerEndpoint(id="monitor-cache")
public class CacheMonitorMvcEndpoint {

    @ResponseBody
    @RequestMapping(
            method = RequestMethod.GET,
            produces = {
                    MediaType.APPLICATION_JSON_VALUE
            },
            value = "/{path}"
    )
    public Object invoke(@PathVariable String path,
            @RequestParam(value="key", required = false)String key,
            @RequestParam(value="cacheName", required = false)String cacheName,
            @RequestParam(value="page", required = false)String page) {
        if (path.equals("all")) {
            return CacheMonitorManager.getAllCache();
        }

        if (path.equals("query")) {
            return this.doQuery(key, cacheName);
        }

        if (path.equals("record")) {
            return this.doRecord(key, cacheName, page);
        }

        if (path.equals("clearAll")) {
            CacheMonitorManager.clearAllCacheValue();
            return Boolean.TRUE;
        }

        return "";
    }

    /**
     * 处理key查询
     *
     * @return
     */
    private Object doQuery(String key, String cacheName) {
        if (StringUtils.isBlank(key) || StringUtils.isBlank(cacheName)) {
            return "";
        }

        return CacheMonitorManager.getCacheValueByKey(cacheName, key);
    }

    /**
     * 处理key查询
     *
     * @return
     */
    private Object doRecord(String key, String cacheName, String page) {
        if (StringUtils.isBlank(page)) {
            page = "1";
        }

        RecordPagerResponse<CacheChangeRecord> records = CacheMonitorManager.getRecord(cacheName, key, Integer.parseInt(page));
        if (records == null) {
            return "";
        }

        return records;
    }
}
