package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import com.google.common.cache.RemovalCause;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-23 11:23
 * @descript:
 * @version: 1.0
 */
class RemovalCauseUtil {

    private static final Map<String, Integer> causeTypeMap = Maps.newHashMap();

    static {

        causeTypeMap.put(RemovalCause.COLLECTED.name(), 1);
        causeTypeMap.put(RemovalCause.EXPIRED.name(), 2);
        causeTypeMap.put(RemovalCause.EXPLICIT.name(), 3);
        causeTypeMap.put(RemovalCause.REPLACED.name(), 4);
        causeTypeMap.put(RemovalCause.SIZE.name(), 5);
    }

    static Integer getTypeByEnumName(String enumName) {
        return causeTypeMap.get(enumName);
    }
}
