package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import org.springframework.http.HttpStatus;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Monitor拦截器, 提供/monitor/start,/monitor/stop,/monitor/check三个url
 */
public class BootMonitorCheckFilter implements Filter{

    @Override
    public void init(FilterConfig filterConfig) {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestPath = RequestUtils.getRequestPath(request);
        if(requestPath.equals("/monitor/check")){//检查服务器状态，OK表示正常，INVALID表示服务不可用
            if(!ServerStatusHolder.isInService()){
                response.setStatus(HttpStatus.SERVICE_UNAVAILABLE.value());
            }
            response.getWriter().write(ServerStatusHolder.isInService() ? "OK" : "INVALID");
        }else if(requestPath.equals("/monitor/stop")){//让check接口返回INVALID
            if(!HttpRequestUtils.isLocalRequest(request)){
                response.getWriter().write("NO PERMISSION");
                return;
            }
            ServerStatusHolder.setInService(false);
            response.getWriter().write("OK");
        }else if(requestPath.equals("/monitor/start")){// 让check接口返回OK
            if(!HttpRequestUtils.isLocalRequest(request)){
                response.getWriter().write("NO PERMISSION");
                return;
            }
            ServerStatusHolder.setInService(true);
            response.getWriter().write("OK");
        }else{
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    @Override
    public void destroy() {
        //do nothing
    }

}
